/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.util.LinkedList;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.EqualsFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.routing.filters.logic.OrFilter;
import org.mule.tck.AbstractMuleTestCase;

public class LogicFiltersTestCase
extends AbstractMuleTestCase {
    public void testAndFilter() {
        AndFilter filter = new AndFilter();
        LogicFiltersTestCase.assertEquals((int)0, (int)filter.getFilters().size());
        LogicFiltersTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo")));
        filter.getFilters().add(new EqualsFilter((Object)"foo"));
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo")));
        filter.getFilters().add(new EqualsFilter((Object)"foo"));
        LogicFiltersTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"bar")));
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo")));
        WildcardFilter left = new WildcardFilter("blah.blah.*");
        WildcardFilter right = new WildcardFilter("blah.*");
        filter = new AndFilter(new Filter[]{left, right});
        LogicFiltersTestCase.assertEquals((int)2, (int)filter.getFilters().size());
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")));
        LogicFiltersTestCase.assertTrue((boolean)right.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")));
        LogicFiltersTestCase.assertTrue((!left.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")) ? 1 : 0) != 0);
        LogicFiltersTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")) ? 1 : 0) != 0);
        filter = new AndFilter();
        filter.getFilters().add(left);
        filter.getFilters().add(right);
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")));
        LogicFiltersTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")) ? 1 : 0) != 0);
    }

    public void testOrFilter() {
        OrFilter filter = new OrFilter();
        LogicFiltersTestCase.assertEquals((int)0, (int)filter.getFilters().size());
        LogicFiltersTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo")));
        WildcardFilter left = new WildcardFilter("blah.blah.*");
        WildcardFilter right = new WildcardFilter("blah.b*");
        filter = new OrFilter(new Filter[]{left, right});
        LogicFiltersTestCase.assertEquals((int)2, (int)filter.getFilters().size());
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")));
        LogicFiltersTestCase.assertTrue((boolean)right.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")));
        LogicFiltersTestCase.assertTrue((!left.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")) ? 1 : 0) != 0);
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")));
        LogicFiltersTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.x.blah")) ? 1 : 0) != 0);
        filter = new OrFilter();
        LinkedList<WildcardFilter> filters = new LinkedList<WildcardFilter>();
        filters.addLast(left);
        filters.addLast(right);
        filter.setFilters(filters);
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")));
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah")));
        LogicFiltersTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.x.blah")) ? 1 : 0) != 0);
    }

    public void testNotFilter() {
        NotFilter notFilter = new NotFilter();
        LogicFiltersTestCase.assertNull((Object)notFilter.getFilter());
        LogicFiltersTestCase.assertFalse((boolean)notFilter.accept((MuleMessage)new DefaultMuleMessage((Object)"foo")));
        LogicFiltersTestCase.assertFalse((boolean)notFilter.accept((MuleMessage)new DefaultMuleMessage(null)));
        WildcardFilter filter = new WildcardFilter("blah.blah.*");
        notFilter = new NotFilter((Filter)filter);
        LogicFiltersTestCase.assertNotNull((Object)notFilter.getFilter());
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")));
        LogicFiltersTestCase.assertTrue((!notFilter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")) ? 1 : 0) != 0);
        notFilter = new NotFilter();
        notFilter.setFilter((Filter)filter);
        LogicFiltersTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")));
        LogicFiltersTestCase.assertTrue((!notFilter.accept((MuleMessage)new DefaultMuleMessage((Object)"blah.blah.blah")) ? 1 : 0) != 0);
    }
}

