/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.service.Service;
import org.mule.routing.AggregationException;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.inbound.AbstractEventAggregator;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.routing.inbound.EventGroup;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class EventAggregatorTestCase
extends AbstractMuleTestCase {
    public void testMessageAggregator() throws Exception {
        Service testService = EventAggregatorTestCase.getTestService("test", Apple.class);
        MuleSession session = EventAggregatorTestCase.getTestSession(testService, muleContext);
        DefaultInboundRouterCollection messageRouter = new DefaultInboundRouterCollection();
        TestEventAggregator router = new TestEventAggregator(3);
        messageRouter.addRouter((InboundRouter)router);
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        router.setMuleContext(muleContext);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A");
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B");
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C");
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        OutboundEndpoint endpoint = EventAggregatorTestCase.getTestOutboundEndpoint("Test1Provider");
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, (ImmutableEndpoint)endpoint, session, false);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, (ImmutableEndpoint)endpoint, session, false);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, (ImmutableEndpoint)endpoint, session, false);
        EventAggregatorTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event1));
        EventAggregatorTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event2));
        EventAggregatorTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event3));
        EventAggregatorTestCase.assertNull((Object)router.process((MuleEvent)event1));
        EventAggregatorTestCase.assertNull((Object)router.process((MuleEvent)event2));
        MuleEvent[] results = router.process((MuleEvent)event3);
        EventAggregatorTestCase.assertNotNull((Object)results);
        EventAggregatorTestCase.assertEquals((int)1, (int)results.length);
        EventAggregatorTestCase.assertEquals((String)"test event A test event B test event C ", (String)results[0].getMessageAsString());
    }

    public static class TestEventAggregator
    extends AbstractEventAggregator {
        protected final int eventThreshold;
        protected int eventCount = 0;

        public TestEventAggregator(int eventThreshold) {
            this.eventThreshold = eventThreshold;
        }

        protected EventCorrelatorCallback getCorrelatorCallback() {
            return new EventCorrelatorCallback(){

                public boolean shouldAggregateEvents(EventGroup events) {
                    ++TestEventAggregator.this.eventCount;
                    if (TestEventAggregator.this.eventCount == TestEventAggregator.this.eventThreshold) {
                        TestEventAggregator.this.eventCount = 0;
                        return true;
                    }
                    return false;
                }

                public EventGroup createEventGroup(MuleEvent event, Object groupId) {
                    return new EventGroup(groupId, TestEventAggregator.this.eventThreshold);
                }

                public MuleMessage aggregateEvents(EventGroup events) throws AggregationException {
                    if (events.size() != TestEventAggregator.this.eventThreshold) {
                        throw new IllegalStateException("eventThreshold not yet reached?");
                    }
                    StringBuffer newPayload = new StringBuffer(80);
                    for (MuleEvent event : events) {
                        try {
                            newPayload.append(event.getMessageAsString()).append(" ");
                        }
                        catch (MuleException e) {
                            throw new AggregationException(events, event.getEndpoint(), (Throwable)e);
                        }
                    }
                    return new DefaultMuleMessage((Object)newPayload.toString(), (Map)null);
                }
            };
        }
    }
}

