/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.util.Comparator;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.service.Service;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.ResequenceCorrelatorCallback;
import org.mule.routing.inbound.CorrelationEventResequencer;
import org.mule.routing.inbound.CorrelationSequenceComparator;
import org.mule.routing.inbound.EventGroup;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class EventResequencerTestCase
extends AbstractMuleTestCase {
    public void testMessageResequencer() throws Exception {
        MuleSession session = EventResequencerTestCase.getTestSession(EventResequencerTestCase.getTestService(), muleContext);
        Service testService = EventResequencerTestCase.getTestService("test", Apple.class);
        EventResequencerTestCase.assertNotNull((Object)testService);
        TestEventResequencer router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A");
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B");
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C");
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        OutboundEndpoint endpoint = EventResequencerTestCase.getTestOutboundEndpoint("Test1Provider");
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, (ImmutableEndpoint)endpoint, session, false);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, (ImmutableEndpoint)endpoint, session, false);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, (ImmutableEndpoint)endpoint, session, false);
        EventResequencerTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event1));
        EventResequencerTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event2));
        EventResequencerTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event3));
        EventResequencerTestCase.assertNull((Object)router.process((MuleEvent)event2));
        EventResequencerTestCase.assertNull((Object)router.process((MuleEvent)event3));
        MuleEvent[] results = router.process((MuleEvent)event1);
        EventResequencerTestCase.assertNotNull((Object)results);
        EventResequencerTestCase.assertEquals((int)3, (int)results.length);
        EventResequencerTestCase.assertEquals((String)"test event B", (String)results[0].getMessageAsString());
        EventResequencerTestCase.assertEquals((String)"test event C", (String)results[1].getMessageAsString());
        EventResequencerTestCase.assertEquals((String)"test event A", (String)results[2].getMessageAsString());
        router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setEventComparator(new EventPayloadComparator());
        router.initialise();
        EventResequencerTestCase.assertNull((Object)router.process((MuleEvent)event2));
        EventResequencerTestCase.assertNull((Object)router.process((MuleEvent)event3));
        results = router.process((MuleEvent)event1);
        EventResequencerTestCase.assertNotNull((Object)results);
        EventResequencerTestCase.assertEquals((int)3, (int)results.length);
        EventResequencerTestCase.assertEquals((String)"test event A", (String)results[0].getMessageAsString());
        EventResequencerTestCase.assertEquals((String)"test event B", (String)results[1].getMessageAsString());
        EventResequencerTestCase.assertEquals((String)"test event C", (String)results[2].getMessageAsString());
    }

    public static class EventPayloadComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                return ((MuleEvent)o1).getMessageAsString().compareTo(((MuleEvent)o2).getMessageAsString());
            }
            catch (MuleException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public static class TestEventResequencer
    extends CorrelationEventResequencer {
        private int eventCount = 0;
        private int eventthreshold = 1;

        public TestEventResequencer(int eventthreshold) {
            this.eventthreshold = eventthreshold;
            this.setEventComparator((Comparator)new CorrelationSequenceComparator());
        }

        protected EventCorrelatorCallback getCorrelatorCallback() {
            return new ResequenceCorrelatorCallback(this.getEventComparator()){

                public boolean shouldAggregateEvents(EventGroup events) {
                    TestEventResequencer.this.eventCount++;
                    if (TestEventResequencer.this.eventCount == TestEventResequencer.this.eventthreshold) {
                        TestEventResequencer.this.eventCount = 0;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

