/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.service.Service;
import org.mule.api.store.ObjectStore;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;

public class IdempotentReceiverTestCase
extends AbstractMuleTestCase {
    public void testIdempotentReceiverDefaultInMemoryObjectStore() throws Exception {
        IdempotentReceiver router = new IdempotentReceiver();
        router.setMuleContext(muleContext);
        this.testIdempotentRouter(router);
    }

    public void testIdempotentReceiverCustomIDStore() throws Exception {
        IdempotentReceiver router = new IdempotentReceiver();
        router.setMuleContext(muleContext);
        router.setStore(new ObjectStore(){
            private Map store = new HashedMap();

            public boolean storeObject(String id, Object item) throws Exception {
                this.store.put(id, item);
                return true;
            }

            public Object retrieveObject(String id) throws Exception {
                return this.store.get(id);
            }

            public boolean removeObject(String id) throws Exception {
                this.store.remove(id);
                return true;
            }

            public boolean containsObject(String id) throws Exception {
                return this.store.containsKey(id);
            }
        });
        router.initialise();
        this.testIdempotentRouter(router);
    }

    protected void testIdempotentRouter(IdempotentReceiver router) throws Exception, MessagingException {
        Mock session = MuleTestUtils.getMockSession();
        Service testService = IdempotentReceiverTestCase.getTestService("test", Apple.class);
        DefaultInboundRouterCollection messageRouter = new DefaultInboundRouterCollection();
        messageRouter.addRouter((InboundRouter)router);
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        OutboundEndpoint endpoint = IdempotentReceiverTestCase.getTestOutboundEndpoint("Test1Provider");
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), false);
        session.expectAndReturn("getService", (Object)testService);
        IdempotentReceiverTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event));
        session.expect("dispatchEvent", (Object)C.eq((Object)event));
        session.expectAndReturn("getService", (Object)testService);
        session.expectAndReturn("getService", (Object)testService);
        messageRouter.route((MuleEvent)event);
        session.verify();
        message = new DefaultMuleMessage((Object)"test event");
        event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), true);
        session.expectAndReturn("sendEvent", (Object)C.eq((Object)event), (Object)message);
        session.expectAndReturn("getService", (Object)testService);
        session.expectAndReturn("getService", (Object)testService);
        MuleMessage result = messageRouter.route((MuleEvent)event);
        IdempotentReceiverTestCase.assertNotNull((Object)result);
        IdempotentReceiverTestCase.assertEquals((Object)message, (Object)result);
        session.verify();
        session.expect("toString");
        session.expectAndReturn("getService", (Object)testService);
        event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), false);
        IdempotentReceiverTestCase.assertTrue((!router.isMatch((MuleEvent)event) ? 1 : 0) != 0);
        messageRouter.route((MuleEvent)event);
        session.verify();
    }
}

