/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.util.ArrayList;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.InvalidEndpointTypeException;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.tck.AbstractMuleTestCase;

public class InboundRouterCollectionTestCase
extends AbstractMuleTestCase {
    public void testAddGoodEndpoint() throws Exception {
        DefaultInboundRouterCollection router = new DefaultInboundRouterCollection();
        InboundEndpoint endpoint = InboundRouterCollectionTestCase.getTestInboundEndpoint("test");
        router.addEndpoint(endpoint);
        InboundRouterCollectionTestCase.assertNotNull((Object)router.getEndpoints());
        InboundRouterCollectionTestCase.assertTrue((boolean)router.getEndpoints().contains(endpoint));
    }

    public void testSetGoodEndpoints() throws Exception {
        ArrayList<InboundEndpoint> list = new ArrayList<InboundEndpoint>();
        list.add(InboundRouterCollectionTestCase.getTestInboundEndpoint("test"));
        list.add(InboundRouterCollectionTestCase.getTestInboundEndpoint("test"));
        DefaultInboundRouterCollection router = new DefaultInboundRouterCollection();
        InboundRouterCollectionTestCase.assertNotNull((Object)router.getEndpoints());
        InboundRouterCollectionTestCase.assertEquals((int)0, (int)router.getEndpoints().size());
        router.addEndpoint(InboundRouterCollectionTestCase.getTestInboundEndpoint("test"));
        InboundRouterCollectionTestCase.assertEquals((int)1, (int)router.getEndpoints().size());
        router.setEndpoints(list);
        InboundRouterCollectionTestCase.assertNotNull((Object)router.getEndpoints());
        InboundRouterCollectionTestCase.assertEquals((int)2, (int)router.getEndpoints().size());
    }

    public void testSetBadEndpoints() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(InboundRouterCollectionTestCase.getTestInboundEndpoint("test"));
        list.add(InboundRouterCollectionTestCase.getTestOutboundEndpoint("test"));
        DefaultInboundRouterCollection router = new DefaultInboundRouterCollection();
        try {
            router.setEndpoints(list);
            InboundRouterCollectionTestCase.fail((String)"Invalid endpoint: Exception exceptions");
        }
        catch (Exception e) {
            InboundRouterCollectionTestCase.assertEquals(InvalidEndpointTypeException.class, e.getClass());
        }
    }

    public void testSetBad2Endpoints() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(InboundRouterCollectionTestCase.getTestInboundEndpoint("test"));
        list.add(InboundRouterCollectionTestCase.getTestOutboundEndpoint("test"));
        DefaultInboundRouterCollection router = new DefaultInboundRouterCollection();
        try {
            router.setEndpoints(list);
            InboundRouterCollectionTestCase.fail((String)"Invalid endpoint: Exception exceptions");
        }
        catch (Exception e) {
            InboundRouterCollectionTestCase.assertEquals(InvalidEndpointTypeException.class, e.getClass());
        }
    }
}

