/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import junit.framework.Assert;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.CollectionUtils;

public class SelectiveConsumerTestCase
extends AbstractMuleTestCase {
    public void testSelectiveConsumer() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        Service testService = SelectiveConsumerTestCase.getTestService("test", Apple.class);
        DefaultInboundRouterCollection messageRouter = new DefaultInboundRouterCollection();
        SelectiveConsumer router = new SelectiveConsumer();
        messageRouter.addRouter((InboundRouter)router);
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router.setFilter((Filter)filter);
        SelectiveConsumerTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        OutboundEndpoint endpoint = SelectiveConsumerTestCase.getTestOutboundEndpoint("Test1Provider");
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), false);
        SelectiveConsumerTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event));
        session.expect("dispatchEvent", (Object)C.eq((Object)event));
        session.expectAndReturn("getService", (Object)testService);
        messageRouter.route((MuleEvent)event);
        session.verify();
        event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), true);
        session.expectAndReturn("sendEvent", (Object)C.eq((Object)event), (Object)message);
        session.expectAndReturn("getService", (Object)testService);
        MuleMessage result = messageRouter.route((MuleEvent)event);
        SelectiveConsumerTestCase.assertNotNull((Object)result);
        SelectiveConsumerTestCase.assertEquals((Object)message, (Object)result);
        session.verify();
        session.expectAndReturn("getService", (Object)testService);
        session.expectAndReturn("toString", (Object)"");
        message = new DefaultMuleMessage((Object)new Exception());
        event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), false);
        SelectiveConsumerTestCase.assertTrue((!router.isMatch((MuleEvent)event) ? 1 : 0) != 0);
        messageRouter.route((MuleEvent)event);
        session.verify();
    }

    public void testSelectiveConsumerWithTransformer() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        Service testService = SelectiveConsumerTestCase.getTestService("test", Apple.class);
        DefaultInboundRouterCollection messageRouter = new DefaultInboundRouterCollection();
        SelectiveConsumer router = new SelectiveConsumer();
        messageRouter.addRouter((InboundRouter)router);
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        PayloadTypeFilter filter = new PayloadTypeFilter(byte[].class);
        router.setFilter((Filter)filter);
        SelectiveConsumerTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        OutboundEndpoint endpoint = SelectiveConsumerTestCase.getTestOutboundEndpoint("Test1Provider", CollectionUtils.singletonList((Object)new ObjectToByteArray()));
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), false);
        SelectiveConsumerTestCase.assertTrue((boolean)router.isMatch((MuleEvent)event));
        session.expect("dispatchEvent", (Object)C.eq((Object)event));
        session.expectAndReturn("getService", (Object)testService);
        messageRouter.route((MuleEvent)event);
        session.verify();
        event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), true);
        session.expectAndReturn("sendEvent", (Object)C.eq((Object)event), (Object)message);
        session.expectAndReturn("getService", (Object)testService);
        MuleMessage result = messageRouter.route((MuleEvent)event);
        SelectiveConsumerTestCase.assertNotNull((Object)result);
        SelectiveConsumerTestCase.assertEquals((Object)message, (Object)result);
        session.verify();
        session.expectAndReturn("getService", (Object)testService);
        session.expectAndReturn("toString", (Object)"");
        message = new DefaultMuleMessage((Object)"Hello String");
        event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, (MuleSession)session.proxy(), false);
        router.setTransformFirst(false);
        SelectiveConsumerTestCase.assertTrue((!router.isMatch((MuleEvent)event) ? 1 : 0) != 0);
        messageRouter.route((MuleEvent)event);
        session.verify();
    }

    public void testConsecutiveSelectiveConsumersWithTransformFirst() throws Exception {
        Service testService = SelectiveConsumerTestCase.getTestService("test", Apple.class);
        DefaultInboundRouterCollection messageRouter = new DefaultInboundRouterCollection();
        TestSelectiveConsumer router = new TestSelectiveConsumer("test");
        router.setFilter((Filter)new PayloadTypeFilter(String.class));
        router.setTransformFirst(true);
        messageRouter.addRouter((InboundRouter)router);
        TestSelectiveConsumer router2 = new TestSelectiveConsumer("test TRANSFORMED");
        messageRouter.addRouter((InboundRouter)router2);
        testService.setInboundRouter((InboundRouterCollection)messageRouter);
        testService.start();
        ArrayList<StringAppendTransformer> transformers = new ArrayList<StringAppendTransformer>();
        transformers.add(new StringAppendTransformer(" TRANSFORMED"));
        messageRouter.route(SelectiveConsumerTestCase.getTestEvent((Object)"test", (ImmutableEndpoint)SelectiveConsumerTestCase.getTestInboundEndpoint("endpoint", transformers)));
    }

    private static class TestSelectiveConsumer
    extends SelectiveConsumer {
        private String expect;

        public TestSelectiveConsumer(String expect) {
            this.expect = expect;
        }

        public boolean isMatch(MuleEvent event) throws MessagingException {
            Assert.assertEquals((Object)this.expect, (Object)event.getMessage().getPayload());
            super.isMatch(event);
            return false;
        }
    }
}

