/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.ExceptionBasedRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class ExceptionBasedRouterTestCase
extends AbstractMuleTestCase {
    public void testSuccessfulExceptionRouterAsynchronous() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getService", (Object)ExceptionBasedRouterTestCase.getTestService());
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundEndpoint endpoint1 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://Dummy1");
        OutboundEndpoint endpoint2 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://Dummy2");
        OutboundEndpoint endpoint3 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://Dummy3");
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        RegExFilter filter = new RegExFilter("(.*) event");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        endpoints.add(endpoint2);
        endpoints.add(endpoint3);
        router.setEndpoints(endpoints);
        ExceptionBasedRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        mockSession.expect("sendEvent", C.eq((Object)message, (Object)endpoint1));
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)mockSession.proxy());
        ExceptionBasedRouterTestCase.assertNull((String)"Async call should've returned null.", (Object)result);
        mockSession.verify();
    }

    public void testSuccessfulExceptionRouterSynchronous() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getService", (Object)ExceptionBasedRouterTestCase.getTestService());
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundEndpoint endpoint1 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://Dummy1?synchronous=true");
        OutboundEndpoint endpoint2 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://Dummy2?synchronous=true");
        OutboundEndpoint endpoint3 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://Dummy3?synchronous=true");
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        RegExFilter filter = new RegExFilter("(.*) event");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        endpoints.add(endpoint2);
        endpoints.add(endpoint3);
        router.setEndpoints(endpoints);
        ExceptionBasedRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        mockSession.expectAndReturn("sendEvent", C.eq((Object)message, (Object)endpoint1), (Object)message);
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)mockSession.proxy());
        ExceptionBasedRouterTestCase.assertNotNull((Object)result);
        ExceptionBasedRouterTestCase.assertEquals((Object)message, (Object)result);
        mockSession.verify();
    }

    public void testBothFailing() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getService", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://AlwaysFail");
        OutboundEndpoint endpoint2 = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint("test://AlwaysFail");
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        RegExFilter filter = new RegExFilter("(.*) event");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        endpoints.add(endpoint2);
        router.setEndpoints(endpoints);
        ExceptionBasedRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        RoutingException rex = new RoutingException((MuleMessage)message, (ImmutableEndpoint)endpoint1);
        mockSession.expectAndThrow("sendEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint1)), (Throwable)rex);
        mockSession.expectAndThrow("dispatchEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint2)), (Throwable)rex);
        MuleSession session = (MuleSession)mockSession.proxy();
        MuleMessage result = null;
        try {
            result = router.route((MuleMessage)message, session);
            ExceptionBasedRouterTestCase.fail((String)"Should have thrown exception as both endpoints would have failed");
        }
        catch (CouldNotRouteOutboundMessageException e) {
            // empty catch block
        }
        ExceptionBasedRouterTestCase.assertNull((String)"Async call should've returned null.", (Object)result);
        mockSession.verify();
        message = new DefaultMuleMessage((Object)"test event");
    }

    public void testFailFirstSuccessSecondSync() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getService", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?synchronous=true");
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?synchronous=true");
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.addEndpoint(endpoint1);
        router.addEndpoint(endpoint2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event");
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)mockSession.proxy();
        RoutingException rex = new RoutingException((MuleMessage)message, (ImmutableEndpoint)endpoint1);
        mockSession.expectAndThrow("sendEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint1)), (Throwable)rex);
        mockSession.expectAndReturn("sendEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint2)), (Object)expectedResultMessage);
        MuleMessage actualResultMessage = router.route((MuleMessage)message, session);
        mockSession.verify();
        ExceptionBasedRouterTestCase.assertEquals((String)"Got an invalid return message.", (Object)expectedResultMessage, (Object)actualResultMessage);
    }

    public void testFailFirstSuccessSecondAsync() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getService", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?synchronous=false");
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?synchronous=false");
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.addEndpoint(endpoint1);
        router.addEndpoint(endpoint2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event");
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)mockSession.proxy();
        RoutingException rex = new RoutingException((MuleMessage)message, (ImmutableEndpoint)endpoint1);
        mockSession.expectAndThrow("sendEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint1)), (Throwable)rex);
        mockSession.expectAndReturn("dispatchEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint2)), (Object)expectedResultMessage);
        MuleMessage actualResultMessage = router.route((MuleMessage)message, session);
        ExceptionBasedRouterTestCase.assertNull((String)"Async call should not return any results.", (Object)actualResultMessage);
        mockSession.verify();
    }

    public void testFirstHadExceptionPayloadSuccessSecondSyncWithExceptionPayload() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getService", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?synchronous=true");
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?synchronous=true");
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.addEndpoint(endpoint1);
        router.addEndpoint(endpoint2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event");
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        DefaultMuleMessage exPayloadMessage = new DefaultMuleMessage((Object)"there was a failure");
        exPayloadMessage.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
        MuleSession session = (MuleSession)mockSession.proxy();
        mockSession.expectAndReturn("sendEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint1)), (Object)exPayloadMessage);
        mockSession.expectAndReturn("sendEvent", C.args((Constraint)C.eq((Object)message), (Constraint)C.eq((Object)endpoint2)), (Object)expectedResultMessage);
        MuleMessage actualResultMessage = router.route((MuleMessage)message, session);
        mockSession.verify();
        ExceptionBasedRouterTestCase.assertEquals((String)"Got an invalid return message.", (Object)expectedResultMessage, (Object)actualResultMessage);
    }
}

