/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.HashMap;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.CollectionUtils;

public class FilteringOutboundRouterTestCase
extends AbstractMuleTestCase {
    public void testFilteringOutboundRouterAsync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)FilteringOutboundRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = FilteringOutboundRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?synchronous=false");
        FilteringOutboundRouterTestCase.assertNotNull((Object)endpoint1);
        FilteringOutboundRouter router = new FilteringOutboundRouter();
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setEndpoints(endpoints);
        FilteringOutboundRouterTestCase.assertFalse((boolean)router.isUseTemplates());
        FilteringOutboundRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        FilteringOutboundRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        session.expect("dispatchEvent", C.eq((Object)message, (Object)endpoint1));
        router.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
        message = new DefaultMuleMessage((Object)new Exception("test event"));
        FilteringOutboundRouterTestCase.assertTrue((!router.isMatch((MuleMessage)message) ? 1 : 0) != 0);
        router.setTransformers(CollectionUtils.singletonList((Object)new AbstractTransformer(){

            public Object doTransform(Object src, String encoding) throws TransformerException {
                return ((Exception)src).getMessage();
            }
        }));
        FilteringOutboundRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
    }

    public void testFilteringOutboundRouterSync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)FilteringOutboundRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = FilteringOutboundRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?synchronous=true");
        FilteringOutboundRouterTestCase.assertNotNull((Object)endpoint1);
        FilteringOutboundRouter router = new FilteringOutboundRouter();
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setEndpoints(endpoints);
        FilteringOutboundRouterTestCase.assertFalse((boolean)router.isUseTemplates());
        FilteringOutboundRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event");
        session.expectAndReturn("sendEvent", C.eq((Object)message, (Object)endpoint1), (Object)message);
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)session.proxy());
        FilteringOutboundRouterTestCase.assertNotNull((Object)result);
        FilteringOutboundRouterTestCase.assertEquals((Object)message, (Object)result);
        session.verify();
    }

    public void testFilteringOutboundRouterWithTemplates() throws Exception {
        OutboundEndpoint endpoint1 = FilteringOutboundRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://foo?[barValue]");
        FilteringOutboundRouterTestCase.assertNotNull((Object)endpoint1);
        FilteringOutboundRouter router = new FilteringOutboundRouter();
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setEndpoints(endpoints);
        FilteringOutboundRouterTestCase.assertTrue((boolean)router.isUseTemplates());
        FilteringOutboundRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("barValue", "bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", m);
        FilteringOutboundRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        OutboundEndpoint ep = router.getEndpoint(0, (MuleMessage)message);
        FilteringOutboundRouterTestCase.assertNotSame((Object)endpoint1, (Object)ep);
        FilteringOutboundRouterTestCase.assertEquals((String)"test://foo?bar", (String)ep.getEndpointURI().toString());
    }
}

