/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.outbound.MulticastingRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.util.mock.PayloadConstraint;

public class MulticastingRouterTestCase
extends AbstractMuleTestCase {
    public void testMulticastingRouterAsync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)MulticastingRouterTestCase.getTestService());
        RegExFilter filter = new RegExFilter("(.*) Message");
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test1", null, (Filter)filter, null);
        MulticastingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test2", null, (Filter)filter, null);
        MulticastingRouterTestCase.assertNotNull((Object)endpoint2);
        MulticastingRouter router = new MulticastingRouter();
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        endpoints.add(endpoint2);
        router.setEndpoints(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message");
        MulticastingRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadConstraint("Test Message"), (Constraint)C.eq((Object)endpoint1)));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadConstraint("Test Message"), (Constraint)C.eq((Object)endpoint2)));
        router.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
    }

    public void testMulticastingRouterSync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)MulticastingRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?synchronous=true");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?synchronous=true");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint2);
        MulticastingRouter router = new MulticastingRouter();
        RegExFilter filter = new RegExFilter("(.*) Message");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        endpoints.add(endpoint2);
        router.setEndpoints(endpoints);
        MulticastingRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message");
        MulticastingRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadConstraint("Test Message"), (Constraint)C.eq((Object)endpoint1)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadConstraint("Test Message"), (Constraint)C.eq((Object)endpoint2)), (Object)message);
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)session.proxy());
        MulticastingRouterTestCase.assertNotNull((Object)result);
        MulticastingRouterTestCase.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MulticastingRouterTestCase.assertEquals((int)2, (int)((MuleMessageCollection)result).size());
        session.verify();
    }

    public void testMulticastingRouterMixedSyncAsync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)MulticastingRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?synchronous=true");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?synchronous=false");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint2);
        MulticastingRouter router = new MulticastingRouter();
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        endpoints.add(endpoint2);
        router.setEndpoints(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message");
        MulticastingRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadConstraint("Test Message"), (Constraint)C.eq((Object)endpoint1)), (Object)message);
        session.expectAndReturn("dispatchEvent", C.args((Constraint)new PayloadConstraint("Test Message"), (Constraint)C.eq((Object)endpoint2)), (Object)message);
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)session.proxy());
        MulticastingRouterTestCase.assertNotNull((Object)result);
        MulticastingRouterTestCase.assertEquals((Object)message, (Object)result);
        session.verify();
    }
}

