/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.config.QueueProfile;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.AbstractConnector;

public class ServiceTestCase
extends AbstractMuleTestCase {
    private Connector testConnector;
    private Service service;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.testConnector = new TestConnector();
        this.testConnector.setName("customTestConnector");
        muleContext.getRegistry().registerConnector(this.testConnector);
        InboundEndpoint inboundEndpoint1 = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("test://test1?connector=customTestConnector");
        InboundEndpoint inboundEndpoint2 = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("test://test2?connector=customTestConnector");
        this.service = new SedaService();
        this.service.setName("testService");
        this.service.getInboundRouter().addEndpoint(inboundEndpoint1);
        this.service.getInboundRouter().addEndpoint(inboundEndpoint2);
        this.service.setModel((Model)new SedaModel());
        ((SedaService)this.service).setQueueProfile(new QueueProfile());
        muleContext.getRegistry().registerService(this.service);
    }

    public void testUnregisterListenersOnServiceDisposal() throws Exception {
        muleContext.start();
        ServiceTestCase.assertEquals((int)2, (int)((AbstractConnector)this.testConnector).getReceivers().size());
        this.service.dispose();
        ServiceTestCase.assertEquals((int)0, (int)((AbstractConnector)this.testConnector).getReceivers().size());
    }

    public void testUnregisterListenersOnServiceStop() throws Exception {
        muleContext.start();
        ServiceTestCase.assertEquals((int)2, (int)((AbstractConnector)this.testConnector).getReceivers().size());
        this.service.stop();
        ServiceTestCase.assertEquals((int)0, (int)((AbstractConnector)this.testConnector).getReceivers().size());
    }
}

