/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import com.mockobjects.dynamic.Mock;
import org.mule.api.transaction.Transaction;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;

public class TransactionCoordinationTestCase
extends AbstractMuleTestCase {
    volatile TransactionCoordination tc;

    protected void doSetUp() throws Exception {
        this.tc = TransactionCoordination.getInstance();
    }

    protected void doTearDown() throws Exception {
        this.tc.unbindTransaction(this.tc.getTransaction());
    }

    public void testBindTransaction() throws Exception {
        TransactionCoordinationTestCase.assertNull((Object)this.tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();
        this.tc.bindTransaction(tx);
        TransactionCoordinationTestCase.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        this.tc.unbindTransaction(tx);
    }

    public void testBindTransactionWithAlreadyBound() throws Exception {
        TransactionCoordinationTestCase.assertNull((Object)this.tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();
        this.tc.bindTransaction(tx);
        TransactionCoordinationTestCase.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        try {
            Transaction tx2 = (Transaction)new Mock(Transaction.class, "trans").proxy();
            this.tc.bindTransaction(tx2);
            TransactionCoordinationTestCase.fail();
        }
        catch (IllegalTransactionStateException illegalTransactionStateException) {
            // empty catch block
        }
        this.tc.unbindTransaction(tx);
    }

    public void testUnbindTransactionWithoutBound() throws Exception {
        TransactionCoordinationTestCase.assertNull((Object)this.tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();
        this.tc.unbindTransaction(tx);
    }

    public void testSetInstanceWithBound() throws Exception {
        TransactionCoordinationTestCase.assertNull((Object)this.tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();
        this.tc.bindTransaction(tx);
        this.tc.unbindTransaction(tx);
    }
}

