/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import junit.framework.Assert;
import org.mule.lifecycle.AlreadyInitialisedException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;

public class ConnectorLifecycleTestCase
extends AbstractMuleTestCase {
    private TestConnector connector;

    public void doSetUp() throws Exception {
        this.connector = new TestConnector();
        this.connector.setMuleContext(muleContext);
        this.connector.initialise();
    }

    public void doTearDown() throws Exception {
        this.connector = null;
    }

    public void testDoubleInitialiseConnector() throws Exception {
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        try {
            System.out.println("Initialising connector again...");
            this.connector.initialise();
            Assert.fail((String)"Expected AlreadyInitialisedException not thrown.");
        }
        catch (AlreadyInitialisedException alreadyInitialisedException) {
            // empty catch block
        }
    }

    public void testDoubleStartConnector() throws Exception {
        System.out.println("Starting connector...");
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        System.out.println("Starting connector again...");
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
    }

    public void testDoubleStopConnector() throws Exception {
        System.out.println("Starting connector...");
        this.connector.start();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        System.out.println("Stopping connector...");
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
        System.out.println("Stopping connector again...");
        this.connector.stop();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnectorStartStop() throws Exception {
        System.out.println("Starting connector...");
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        System.out.println("Stopping connector...");
        this.connector.stop();
        ConnectorLifecycleTestCase.assertFalse((boolean)this.connector.isStarted());
        System.out.println("Disposing connector...");
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        System.out.println("Disposing connector again...");
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnectorStartOnly() throws Exception {
        System.out.println("Starting connector...");
        this.connector.start();
        ConnectorLifecycleTestCase.assertTrue((boolean)this.connector.isStarted());
        System.out.println("Disposing connector...");
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        System.out.println("Disposing connector again...");
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }

    public void testDoubleDisposeConnector() throws Exception {
        System.out.println("Disposing connector...");
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
        System.out.println("Disposing connector again...");
        this.connector.dispose();
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getInitialiseCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getConnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStartCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getStopCount());
        ConnectorLifecycleTestCase.assertEquals((int)0, (int)this.connector.getDisconnectCount());
        ConnectorLifecycleTestCase.assertEquals((int)1, (int)this.connector.getDisposeCount());
    }
}

