/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Arrays;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;

public class StringUtilsTestCase
extends AbstractMuleTestCase {
    public void testSplitAndTrim1() {
        Object[] result = StringUtils.splitAndTrim(null, (String)",,");
        StringUtilsTestCase.assertNull((Object)result);
        result = StringUtils.splitAndTrim((String)"", (String)",");
        StringUtilsTestCase.assertNotNull((Object)result);
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, result));
        result = StringUtils.splitAndTrim((String)" ", (String)",");
        StringUtilsTestCase.assertNotNull((Object)result);
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, result));
    }

    public void testSplitAndTrim2() {
        Object[] inputValues = new String[]{"foo", "bar", "baz", "kaboom"};
        String inputString = new StringBuffer(40).append(inputValues[0]).append(" ,").append(",  ").append(inputValues[1]).append(" ,").append(inputValues[2]).append("  ,  ").append(inputValues[3]).append(" ").toString();
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(inputValues, StringUtils.splitAndTrim((String)inputString, (String)",")));
    }

    public void testSplitAndTrim3() {
        Object[] inputValues = new String[]{"foo", "bar", "baz", "kaboom"};
        String inputString = "foo,  bar,\nbaz,  \nkaboom";
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(inputValues, StringUtils.splitAndTrim((String)inputString, (String)",")));
    }

    public void testHexStringToByteArray() {
        StringUtilsTestCase.assertNull((Object)StringUtils.hexStringToByteArray(null));
        try {
            StringUtils.hexStringToByteArray((String)"1");
            StringUtilsTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[0], StringUtils.hexStringToByteArray((String)"")));
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[]{1}, StringUtils.hexStringToByteArray((String)"01")));
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[]{1, 2}, StringUtils.hexStringToByteArray((String)"0102")));
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[]{10, 14}, StringUtils.hexStringToByteArray((String)"0A0E")));
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[]{10, 14}, StringUtils.hexStringToByteArray((String)"0a0e")));
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[]{10, -1}, StringUtils.hexStringToByteArray((String)"0AFF")));
        StringUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[]{10, -1}, StringUtils.hexStringToByteArray((String)"0aff")));
    }

    public void testByteArrayToHexString() {
        StringUtilsTestCase.assertNull((Object)StringUtils.toHexString(null));
        StringUtilsTestCase.assertEquals((String)"", (String)StringUtils.toHexString((byte[])new byte[0]));
        StringUtilsTestCase.assertEquals((String)"01", (String)StringUtils.toHexString((byte[])new byte[]{1}));
        StringUtilsTestCase.assertEquals((String)"0102", (String)StringUtils.toHexString((byte[])new byte[]{1, 2}));
        StringUtilsTestCase.assertEquals((String)"0a0e", (String)StringUtils.toHexString((byte[])new byte[]{10, 14}));
        StringUtilsTestCase.assertEquals((String)"0A0E", (String)StringUtils.toHexString((byte[])new byte[]{10, 14}, (boolean)true));
        StringUtilsTestCase.assertEquals((String)"0aff", (String)StringUtils.toHexString((byte[])new byte[]{10, -1}));
        StringUtilsTestCase.assertEquals((String)"0AFF", (String)StringUtils.toHexString((byte[])new byte[]{10, -1}, (boolean)true));
    }
}

