/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mule.api.MessagingException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.util.UUID;

public class HttpRequestMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -4238448252206941125L;
    private HttpServletRequest request;

    public HttpRequestMessageAdapter(Object message) throws MessagingException {
        HashMap<String, Object> headers;
        if (message instanceof HttpServletRequest) {
            String key;
            Object value;
            this.setPayload((HttpServletRequest)message);
            this.setContentEncoding((HttpServletRequest)message);
            headers = new HashMap<String, Object>();
            Map parameterMap = this.request.getParameterMap();
            if (parameterMap != null && parameterMap.size() > 0) {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    String key2 = (String)entry.getKey();
                    value = entry.getValue();
                    if (value == null) continue;
                    if (value.getClass().isArray() && ((Object[])value).length == 1) {
                        headers.put(key2, ((Object[])value)[0]);
                        continue;
                    }
                    headers.put(key2, value);
                }
            }
            Enumeration e = this.request.getAttributeNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                headers.put(key, this.request.getAttribute(key));
            }
            Enumeration e2 = this.request.getHeaderNames();
            while (e2.hasMoreElements()) {
                String realKey = key = (String)e2.nextElement();
                if (key.startsWith("X-MULE_")) {
                    realKey = key.substring(2);
                }
                value = this.request.getHeader(key);
                if ("Host".equalsIgnoreCase(key)) {
                    realKey = "Host";
                    int port = this.request.getLocalPort();
                    if (!((String)value).contains(":") && port != 80 && port != 443) {
                        value = (String)value + ":" + port;
                    }
                }
                headers.put(realKey, value);
            }
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
        this.addInboundProperties(headers);
    }

    protected void setContentEncoding(HttpServletRequest request) {
        int i;
        String contentType = request.getContentType();
        if (contentType != null && (i = contentType.indexOf("charset")) > -1) {
            int x = contentType.lastIndexOf(";");
            if (x > i) {
                this.setEncoding(contentType.substring(i + 8, x));
            } else {
                this.setEncoding(contentType.substring(i + 8));
            }
        }
    }

    protected HttpRequestMessageAdapter(HttpRequestMessageAdapter template) {
        super(template);
        this.request = template.request;
    }

    public Object getPayload() {
        try {
            if ("GET".equalsIgnoreCase(this.request.getMethod())) {
                return this.request.getRequestURI().toString() + "?" + this.request.getQueryString();
            }
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBinary() {
        return !this.request.getContentType().startsWith("text");
    }

    private void setPayload(HttpServletRequest message) throws MessagingException {
        this.request = message;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getUniqueId() {
        HttpSession session = null;
        try {
            session = this.getRequest().getSession(false);
        }
        catch (Exception e) {
            return UUID.getUUID();
        }
        if (session == null) {
            return UUID.getUUID();
        }
        return session.getId();
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null && replyTo.toString().startsWith("http")) {
            this.setProperty("Location", replyTo);
        }
        this.setProperty("MULE_REPLYTO", replyTo);
    }

    public Object getReplyTo() {
        Object replyto = this.getProperty("MULE_REPLYTO");
        if (replyto == null) {
            replyto = this.getProperty("Location");
        }
        return replyto;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new HttpRequestMessageAdapter(this);
    }
}

