/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transport.MessageReceiver;
import org.mule.component.DefaultJavaComponent;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.model.seda.SedaService;
import org.mule.object.SingletonObjectFactory;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.transport.AbstractConnector;
import org.mule.transport.cxf.CxfMessageReceiver;
import org.mule.transport.cxf.CxfServiceComponent;
import org.mule.transport.cxf.transport.MuleUniversalTransport;
import org.springframework.context.ApplicationContext;

public class CxfConnector
extends AbstractConnector
implements MuleContextNotificationListener {
    public static final String CXF = "cxf";
    public static final String CXF_SERVICE_COMPONENT_NAME = "_cxfServiceComponent";
    public static final String CONFIGURATION_LOCATION = "configurationLocation";
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String BUS_PROPERTY = "cxf";
    private Bus bus;
    private String configurationLocation;
    private String defaultFrontend = "jaxws";
    private List<SedaService> services = Collections.synchronizedList(new ArrayList());
    private Map<String, Server> uriToServer = new HashMap<String, Server>();
    private boolean initializeStaticBusInstance = true;

    public CxfConnector() {
        this.registerProtocols();
    }

    protected void registerProtocols() {
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol("https");
        this.registerSupportedProtocol("jms");
        this.registerSupportedProtocol("vm");
    }

    public boolean supportsProtocol(String protocol) {
        return protocol.startsWith("cxf:") || super.supportsProtocol(protocol);
    }

    public String getProtocol() {
        return "cxf";
    }

    protected void doInitialise() throws InitialisationException {
        ApplicationContext context = (ApplicationContext)this.muleContext.getRegistry().lookupObject("springApplicationContext");
        this.bus = this.configurationLocation != null ? new SpringBusFactory(context).createBus(this.configurationLocation, true) : new SpringBusFactory(context).createBus((String)null, true);
        if (!this.initializeStaticBusInstance) {
            BusFactory.setDefaultBus(null);
        }
        MuleUniversalTransport transport = new MuleUniversalTransport(this);
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/soap/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/http/configuration", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/http/", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://www.w3.org/2003/05/soap/bindings/HTTP/", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://mule.codehaus.org/cxf", (DestinationFactory)transport);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/soap/http", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://mule.codehaus.org/cxf", (ConduitInitiator)transport);
        try {
            this.muleContext.registerListener((ServerNotificationListener)this);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
        this.bus.shutdown(true);
    }

    public Bus getCxfBus() {
        return this.bus;
    }

    public void setCxfBus(Bus bus) {
        this.bus = bus;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public String getDefaultFrontend() {
        return this.defaultFrontend;
    }

    public void setDefaultFrontend(String defaultFrontend) {
        this.defaultFrontend = defaultFrontend;
    }

    protected void registerReceiverWithMuleService(MessageReceiver receiver, EndpointURI ep) throws MuleException {
        EndpointURIEndpointBuilder secFilterEndpoint;
        EndpointURIEndpointBuilder filterEndpoint;
        EndpointURIEndpointBuilder transformerEndpoint;
        CxfMessageReceiver cxfReceiver = (CxfMessageReceiver)receiver;
        Server server = cxfReceiver.getServer();
        this.uriToServer.put(server.getEndpoint().getEndpointInfo().getAddress(), server);
        SedaService service = new SedaService();
        service.setMuleContext(this.muleContext);
        service.setName(CXF_SERVICE_COMPONENT_NAME + server.getEndpoint().getService().getName() + service.hashCode());
        service.setModel(this.muleContext.getRegistry().lookupSystemModel());
        CxfServiceComponent svcComponent = new CxfServiceComponent(this, (CxfMessageReceiver)receiver);
        svcComponent.setBus(this.bus);
        DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)new SingletonObjectFactory((Object)svcComponent));
        component.setMuleContext(this.muleContext);
        service.setComponent((Component)component);
        String endpoint = receiver.getEndpointURI().getAddress();
        String scheme = ep.getScheme().toLowerCase();
        InboundEndpoint originalEndpoint = receiver.getEndpoint();
        boolean sync = originalEndpoint.isSynchronous();
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp") || scheme.equals("servlet")) {
            originalEndpoint.getProperties().put("http.method", "POST");
            originalEndpoint.getProperties().put("Content-Type", "text/xml");
        }
        QName serviceName = server.getEndpoint().getEndpointInfo().getName();
        EndpointURIEndpointBuilder protocolEndpointBuilder = new EndpointURIEndpointBuilder(endpoint, this.muleContext);
        protocolEndpointBuilder.setSynchronous(sync);
        protocolEndpointBuilder.setName(ep.getScheme() + ":" + serviceName.getLocalPart());
        protocolEndpointBuilder.setTransactionConfig(originalEndpoint.getTransactionConfig());
        EndpointURIEndpointBuilder receiverEndpointBuilder = new EndpointURIEndpointBuilder((ImmutableEndpoint)originalEndpoint, this.muleContext);
        if (cxfReceiver.isApplyTransformersToProtocol()) {
            transformerEndpoint = protocolEndpointBuilder;
            receiverEndpointBuilder.setTransformers(Collections.emptyList());
            receiverEndpointBuilder.setResponseTransformers(Collections.emptyList());
        } else {
            transformerEndpoint = receiverEndpointBuilder;
        }
        if (originalEndpoint.getTransformers() != null && !originalEndpoint.getTransformers().isEmpty()) {
            transformerEndpoint.setTransformers(originalEndpoint.getTransformers());
        }
        if (originalEndpoint.getResponseTransformers() != null && !originalEndpoint.getResponseTransformers().isEmpty()) {
            transformerEndpoint.setResponseTransformers(originalEndpoint.getResponseTransformers());
        }
        if (cxfReceiver.isApplyFiltersToProtocol()) {
            filterEndpoint = protocolEndpointBuilder;
            receiverEndpointBuilder.setFilter(null);
        } else {
            filterEndpoint = receiverEndpointBuilder;
        }
        filterEndpoint.setFilter(originalEndpoint.getFilter());
        if (cxfReceiver.isApplySecurityToProtocol()) {
            secFilterEndpoint = protocolEndpointBuilder;
            receiverEndpointBuilder.setSecurityFilter(null);
        } else {
            secFilterEndpoint = receiverEndpointBuilder;
        }
        secFilterEndpoint.setSecurityFilter(originalEndpoint.getSecurityFilter());
        String connectorName = (String)originalEndpoint.getProperty((Object)"protocolConnector");
        if (connectorName != null) {
            protocolEndpointBuilder.setConnector(this.muleContext.getRegistry().lookupConnector(connectorName));
        }
        InboundEndpoint protocolEndpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)protocolEndpointBuilder);
        InboundEndpoint receiverEndpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)receiverEndpointBuilder);
        receiver.setEndpoint(receiverEndpoint);
        service.setInboundRouter((InboundRouterCollection)new DefaultInboundRouterCollection());
        service.getInboundRouter().addEndpoint(protocolEndpoint);
        this.services.add(service);
    }

    protected Object getReceiverKey(Service service, InboundEndpoint endpoint) {
        if (service.getName().startsWith(CXF_SERVICE_COMPONENT_NAME)) {
            return service.getName();
        }
        return endpoint.getEndpointURI().getAddress();
    }

    public void onNotification(ServerNotification event) {
        if (event.getAction() == 104) {
            for (SedaService service : this.services) {
                try {
                    this.muleContext.getRegistry().registerService((Service)service);
                }
                catch (MuleException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        }
    }

    public boolean isSyncEnabled(String protocol) {
        if ((protocol = protocol.toLowerCase()).equals("http") || protocol.equals("https") || protocol.equals("ssl") || protocol.equals("tcp") || protocol.equals("servlet")) {
            return true;
        }
        return super.isSyncEnabled(protocol);
    }

    public Server getServer(String uri) {
        return this.uriToServer.get(uri);
    }

    public boolean isInitializeStaticBusInstance() {
        return this.initializeStaticBusInstance;
    }

    public void setInitializeStaticBusInstance(boolean initializeStaticBusInstance) {
        this.initializeStaticBusInstance = initializeStaticBusInstance;
    }
}

