/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.cxf.ClientWrapper;
import org.mule.transport.cxf.CxfConnector;
import org.mule.util.TemplateParser;

public class CxfMessageDispatcher
extends AbstractMessageDispatcher {
    private static final String URI_REGEX = "cxf:\\[(.+?)\\]:(.+?)/\\[(.+?)\\]:(.+?)";
    Pattern URI_PATTERN = Pattern.compile("cxf:\\[(.+?)\\]:(.+?)/\\[(.+?)\\]:(.+?)");
    protected final CxfConnector connector;
    protected ClientWrapper wrapper;
    private final TemplateParser soapActionTemplateParser = TemplateParser.createMuleStyleParser();

    public CxfMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (CxfConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        this.wrapper = new ClientWrapper();
        this.wrapper.setBus(this.connector.getCxfBus());
        this.wrapper.setEndpoint(this.endpoint);
        this.wrapper.initialize();
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    protected Object[] getArgs(MuleEvent event) throws TransformerException {
        Object payload = this.wrapper.isApplyTransformersToProtocol() ? event.getMessage().getPayload() : event.transformMessage();
        if (this.wrapper.isProxy()) {
            return new Object[]{event.getMessage()};
        }
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        MuleMessage message = event.getMessage();
        Set attachmentNames = message.getAttachmentNames();
        if (attachmentNames != null && !attachmentNames.isEmpty()) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            Iterator i = attachmentNames.iterator();
            while (i.hasNext()) {
                attachments.add(message.getAttachment((String)i.next()));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[0]));
            args = temp.toArray();
        }
        if (args.length == 0) {
            return null;
        }
        return args;
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        ((ClientImpl)this.wrapper.getClient()).setSynchronousTimeout(event.getTimeout());
        MuleMessage res = !this.wrapper.isClientProxyAvailable() ? this.doSendWithClient(event) : this.doSendWithProxy(event);
        return res;
    }

    protected MuleMessage doSendWithProxy(MuleEvent event) throws Exception {
        Method method = this.wrapper.getMethod(event);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("MULE_EVENT", event);
        Holder holder = new Holder();
        props.put("holder", holder);
        String soapAction = (String)event.getMessage().getProperty("soapAction");
        if (soapAction != null) {
            soapAction = this.parseSoapAction(soapAction, new QName(method.getName()), event);
            props.put("SOAPAction", soapAction);
        }
        BindingProvider bp = this.wrapper.getClientProxy();
        bp.getRequestContext().putAll(props);
        Object response = method.invoke((Object)this.wrapper.getClientProxy(), this.getArgs(event));
        MuleMessage muleRes = (MuleMessage)holder.value;
        return this.buildResponseMessage(muleRes, new Object[]{response});
    }

    protected MuleMessage doSendWithClient(MuleEvent event) throws Exception {
        BindingOperationInfo bop = this.wrapper.getOperation(event);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("MULE_EVENT", event);
        Holder holder = new Holder();
        props.put("holder", holder);
        String soapAction = (String)event.getMessage().getProperty("soapAction");
        if (soapAction != null) {
            soapAction = this.parseSoapAction(soapAction, bop.getName(), event);
            props.put("SOAPAction", soapAction);
            event.getMessage().setProperty("soapAction", (Object)soapAction);
        }
        HashMap<String, HashMap<String, Object>> ctx = new HashMap<String, HashMap<String, Object>>();
        ctx.put("RequestContext", props);
        ctx.put("ResponseContext", props);
        Object[] arr = event.getMessage().getPropertyNames().toArray();
        for (int i = 0; i < arr.length; ++i) {
            String head = (String)arr[i];
            if (head == null || head.startsWith("MULE")) continue;
            props.put((String)arr[i], event.getMessage().getProperty((String)arr[i]));
        }
        Object[] response = this.wrapper.getClient().invoke(bop, this.getArgs(event), ctx);
        MuleMessage muleRes = (MuleMessage)holder.value;
        return this.buildResponseMessage(muleRes, response);
    }

    protected MuleMessage buildResponseMessage(MuleMessage transportResponse, Object[] response) {
        if (transportResponse == null) {
            return null;
        }
        DefaultMuleMessage result = null;
        if (response != null && response.length <= 1) {
            if (response.length == 1) {
                result = new DefaultMuleMessage(response[0], (MessageAdapter)transportResponse);
            }
        } else {
            result = new DefaultMuleMessage((Object)response, (MessageAdapter)transportResponse);
        }
        return result;
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        this.doSend(event);
    }

    public String parseSoapAction(String soapAction, QName method, MuleEvent event) {
        EndpointURI endpointURI = event.getEndpoint().getEndpointURI();
        HashMap<String, String> properties = new HashMap<String, String>();
        MuleMessage msg = event.getMessage();
        for (String propertyKey : msg.getPropertyNames()) {
            properties.put(propertyKey, msg.getProperty(propertyKey).toString());
        }
        properties.put("method", method.getLocalPart());
        properties.put("methodNamespace", method.getNamespaceURI());
        properties.put("address", endpointURI.getAddress());
        properties.put("scheme", endpointURI.getScheme());
        properties.put("host", endpointURI.getHost());
        properties.put("port", String.valueOf(endpointURI.getPort()));
        properties.put("path", endpointURI.getPath());
        properties.put("hostInfo", endpointURI.getScheme() + "://" + endpointURI.getHost() + (endpointURI.getPort() > -1 ? ":" + String.valueOf(endpointURI.getPort()) : ""));
        if (event.getService() != null) {
            properties.put("serviceName", event.getService().getName());
        }
        soapAction = this.soapActionTemplateParser.parse(properties, soapAction);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SoapAction for this call is: " + soapAction));
        }
        return soapAction;
    }
}

