/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf.wsdl;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.transport.cxf.ClientWrapper;
import org.mule.transport.cxf.CxfMessageDispatcher;
import org.mule.util.StringUtils;

public class CxfWsdlMessageDispatcher
extends CxfMessageDispatcher {
    private static final Object CLIENT_CREATION_LOCK = new Object();

    public CxfWsdlMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    protected void doConnect() throws Exception {
        try {
            this.wrapper = new ClientWrapper(){

                public void initialize() throws Exception, IOException {
                    String wsdlUrl = this.endpoint.getEndpointURI().getAddress();
                    String serviceName = null;
                    String portName = null;
                    if (this.endpoint.getProperty((Object)"wsdlLocation") != null && StringUtils.isNotBlank((String)this.endpoint.getProperty((Object)"wsdlLocation").toString())) {
                        wsdlUrl = (String)this.endpoint.getProperty((Object)"wsdlLocation");
                    }
                    if (this.endpoint.getProperty((Object)"service") != null && StringUtils.isNotBlank((String)this.endpoint.getProperty((Object)"service").toString())) {
                        serviceName = (String)this.endpoint.getProperty((Object)"service");
                    }
                    if (this.endpoint.getProperty((Object)"port") != null && StringUtils.isNotBlank((String)this.endpoint.getProperty((Object)"port").toString())) {
                        portName = (String)this.endpoint.getProperty((Object)"port");
                    }
                    try {
                        this.client = CxfWsdlMessageDispatcher.this.createClient(this.bus, wsdlUrl, serviceName, portName);
                        this.addMuleInterceptors();
                    }
                    catch (Exception ex) {
                        CxfWsdlMessageDispatcher.this.disconnect();
                        throw ex;
                    }
                }
            };
            this.wrapper.setBus(this.connector.getCxfBus());
            this.wrapper.setEndpoint(this.endpoint);
            this.wrapper.initialize();
        }
        catch (Exception ex) {
            this.disconnect();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Client createClient(Bus bus, String wsdlUrl, String serviceName, String portName) throws Exception {
        Object object = CLIENT_CREATION_LOCK;
        synchronized (object) {
            DynamicClientFactory cf = DynamicClientFactory.newInstance((Bus)bus);
            return cf.createClient(wsdlUrl, serviceName == null ? null : QName.valueOf(serviceName), portName == null ? null : QName.valueOf(portName));
        }
    }
}

