/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.filters;

import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;

public class IsJsonFilter
implements Filter {
    protected final transient Log logger = LogFactory.getLog(IsJsonFilter.class);
    private boolean validateParsing = false;

    public boolean accept(MuleMessage obj) {
        return this.accept(obj.getPayload());
    }

    public boolean accept(Object obj) {
        try {
            if (obj instanceof String) {
                if (!JSONUtils.mayBeJSON((String)((String)obj))) {
                    return false;
                }
                if (this.isValidateParsing()) {
                    JSONObject.fromObject((Object)obj);
                }
            } else {
                return false;
            }
            this.logger.debug((Object)"Filter result = true (message is valid JSON)");
            return true;
        }
        catch (JSONException e) {
            this.logger.debug((Object)("Filter result = false (message is not valid JSON): " + e.getMessage()));
            return false;
        }
    }

    public boolean isValidateParsing() {
        return this.validateParsing;
    }

    public void setValidateParsing(boolean validateParsing) {
        this.validateParsing = validateParsing;
    }
}

