/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message.stream;

import cryptix.pki.KeyBundle;
import java.security.PrivateKey;
import javax.crypto.SecretKey;

public class DecryptionKeyReturnValue {
    public static final int NOERROR = 0;
    public static final int FAIL = 1;
    private int error;
    private SecretKey seckey;
    private PrivateKey privkey;
    private KeyBundle bundle;
    private char[] passphrase;

    public DecryptionKeyReturnValue(int error) {
        if (error <= 0 || error > 1) {
            throw new IllegalArgumentException("Invalid error");
        }
        this.error = error;
    }

    public DecryptionKeyReturnValue(KeyBundle bundle, char[] passphrase) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        this.error = 0;
        this.bundle = bundle;
        this.passphrase = passphrase;
    }

    public DecryptionKeyReturnValue(PrivateKey privkey) {
        if (privkey == null) {
            throw new IllegalArgumentException("Null key");
        }
        this.error = 0;
        this.privkey = privkey;
    }

    public DecryptionKeyReturnValue(SecretKey seckey) {
        if (seckey == null) {
            throw new IllegalArgumentException("Null key");
        }
        this.error = 0;
        this.seckey = seckey;
    }

    public DecryptionKeyReturnValue(char[] passphrase) {
        if (this.bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        this.error = 0;
        this.bundle = this.bundle;
        this.passphrase = passphrase;
    }

    public KeyBundle getBundle() {
        return this.bundle;
    }

    public int getError() {
        return this.error;
    }

    public char[] getPassphrase() {
        return this.passphrase;
    }

    public PrivateKey getPrivateKey() {
        return this.privkey;
    }

    public SecretKey getSecretKey() {
        return this.seckey;
    }
}

