/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageAdapter;
import org.mule.transport.http.HttpResponseException;
import org.mule.transport.http.MuleHttpMethodRetryHandler;
import org.mule.transport.http.ReleasingInputStream;
import org.mule.transport.http.StreamPayloadRequestEntity;
import org.mule.transport.http.transformers.ObjectToHttpClientMethodRequest;
import org.mule.util.StringUtils;

public class HttpClientMessageDispatcher
extends AbstractMessageDispatcher {
    public static final int ERROR_STATUS_CODE_RANGE_START = 400;
    private final HttpConnector connector;
    private volatile HttpClient client = null;
    private final ObjectToHttpClientMethodRequest sendTransformer;

    public HttpClientMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (HttpConnector)endpoint.getConnector();
        this.sendTransformer = new ObjectToHttpClientMethodRequest();
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.sendTransformer.setMuleContext(this.connector.getMuleContext());
        this.sendTransformer.initialise();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            this.client = this.connector.doClientConnect();
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(MuleEvent event) throws Exception {
        HttpMethod httpMethod = this.getMethod(event);
        try {
            this.execute(event, httpMethod);
            if (httpMethod.getStatusCode() >= 400) {
                this.logger.error((Object)httpMethod.getResponseBodyAsString());
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new Exception("Http call returned a status of: " + httpMethod.getStatusCode() + " " + httpMethod.getStatusText()));
            }
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    protected HttpMethod execute(MuleEvent event, HttpMethod httpMethod) throws Exception {
        try {
            URI uri = event.getEndpoint().getEndpointURI().getUri();
            this.processCookies(event);
            this.client.executeMethod(this.getHostConfig(uri), httpMethod);
            return httpMethod;
        }
        catch (IOException e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected void processCookies(MuleEvent event) {
        MuleMessage msg = event.getMessage();
        this.processCookies(msg.removeProperty("cookies"), (String)msg.removeProperty("cookieSpec"));
        this.processCookies(this.endpoint.getProperty((Object)"cookies"), (String)this.endpoint.getProperty((Object)"cookieSpec"));
    }

    private void processCookies(Object cookieObject, String policy) {
        if (cookieObject instanceof Cookie[]) {
            Cookie[] cookies = (Cookie[])cookieObject;
            if (cookies != null && cookies.length > 0) {
                this.client.getParams().setCookiePolicy(CookieHelper.getCookiePolicy(policy));
                this.client.getState().addCookies(cookies);
            }
        } else if (cookieObject instanceof Map) {
            this.client.getParams().setCookiePolicy("rfc2109");
            String host = this.getEndpoint().getEndpointURI().getHost();
            String path = this.getEndpoint().getEndpointURI().getPath();
            Map cookieMap = (Map)cookieObject;
            for (String key : cookieMap.keySet()) {
                String value = (String)cookieMap.get(key);
                Cookie cookie = new Cookie(host, key, value, path, null, false);
                this.client.getState().addCookie(cookie);
            }
        } else if (cookieObject != null) {
            throw new IllegalArgumentException("Invalid cookies " + cookieObject);
        }
    }

    protected HttpMethod getMethod(MuleEvent event) throws TransformerException {
        MuleMessage msg = event.getMessage();
        this.setPropertyFromEndpoint(event, msg, "http.custom.headers");
        Object body = event.transformMessage();
        HttpMethod httpMethod = body instanceof HttpMethod ? (HttpMethod)body : (HttpMethod)this.sendTransformer.transform(msg);
        httpMethod.setFollowRedirects(this.connector.isFollowRedirects());
        return httpMethod;
    }

    protected void setPropertyFromEndpoint(MuleEvent event, MuleMessage msg, String prop) {
        Object o = msg.getProperty(prop, PropertyScope.OUTBOUND);
        if (o == null && (o = event.getEndpoint().getProperty((Object)prop)) != null) {
            msg.setProperty(prop, o);
        }
    }

    protected HttpMethod createEntityMethod(MuleEvent event, Object body, EntityEnclosingMethod postMethod) throws TransformerException {
        HttpMethod httpMethod;
        if (body instanceof String) {
            ObjectToHttpClientMethodRequest trans = new ObjectToHttpClientMethodRequest();
            httpMethod = (HttpMethod)trans.transform(body.toString());
        } else if (body instanceof byte[]) {
            byte[] buffer = event.transformMessageToBytes();
            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, event.getEncoding()));
            httpMethod = postMethod;
        } else {
            if (!(body instanceof OutputHandler)) {
                body = event.transformMessage(OutputHandler.class);
            }
            OutputHandler outputHandler = (OutputHandler)body;
            postMethod.setRequestEntity((RequestEntity)new StreamPayloadRequestEntity(outputHandler, event));
            postMethod.setContentChunked(true);
            httpMethod = postMethod;
        }
        return httpMethod;
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        HttpMethod httpMethod = this.getMethod(event);
        this.connector.setupClientAuthorization(event, httpMethod, this.client, this.endpoint);
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new MuleHttpMethodRetryHandler());
        Object body = null;
        boolean releaseConn = false;
        try {
            Object is;
            httpMethod = this.execute(event, httpMethod);
            DefaultExceptionPayload ep = null;
            if (httpMethod.getStatusCode() >= 400) {
                ep = new DefaultExceptionPayload((Throwable)new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new HttpResponseException(httpMethod.getStatusText(), httpMethod.getStatusCode())));
            }
            if ((is = httpMethod.getResponseBodyAsStream()) == null) {
                body = "";
                releaseConn = true;
            } else {
                is = new ReleasingInputStream((InputStream)is, httpMethod);
                body = is;
            }
            Header[] headers = httpMethod.getResponseHeaders();
            HttpMessageAdapter adapter = new HttpMessageAdapter(new Object[]{body, headers});
            String status = String.valueOf(httpMethod.getStatusCode());
            adapter.setProperty("http.status", status);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Http response is: " + status));
            }
            DefaultMuleMessage m = new DefaultMuleMessage((Object)adapter);
            m.setExceptionPayload((ExceptionPayload)ep);
            DefaultMuleMessage defaultMuleMessage = m;
            return defaultMuleMessage;
        }
        catch (Exception e) {
            releaseConn = true;
            if (e instanceof DispatchException) {
                throw (DispatchException)e;
            }
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        finally {
            if (releaseConn) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected HostConfiguration getHostConfig(URI uri) throws URISyntaxException {
        Protocol protocol = Protocol.getProtocol((String)uri.getScheme().toLowerCase());
        String host = uri.getHost();
        int port = uri.getPort();
        HostConfiguration config = new HostConfiguration();
        config.setHost(host, port, protocol);
        if (StringUtils.isNotBlank((String)this.connector.getProxyHostname())) {
            config.setProxy(this.connector.getProxyHostname(), this.connector.getProxyPort());
        }
        return config;
    }

    protected void doDispose() {
    }
}

