/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.model.streaming.CallbackOutputStream;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;
import org.mule.transport.file.FilenameParser;
import org.mule.transport.file.SimpleFilenameParser;
import org.mule.transport.ftp.FtpConnectionFactory;
import org.mule.util.ClassUtils;

public class FtpConnector
extends AbstractConnector {
    public static final String FTP = "ftp";
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    public static final int DEFAULT_POLLING_FREQUENCY = 1000;
    public static final String PROPERTY_OUTPUT_PATTERN = "outputPattern";
    public static final String PROPERTY_PASSIVE_MODE = "passive";
    public static final String PROPERTY_BINARY_TRANSFER = "binary";
    public static final String PROPERTY_FILENAME = "filename";
    public static final String DEFAULT_FTP_CONNECTION_FACTORY_CLASS = "org.mule.transport.ftp.FtpConnectionFactory";
    private long pollingFrequency;
    private String outputPattern;
    private FilenameParser filenameParser = new SimpleFilenameParser();
    private boolean passive = true;
    private boolean binary = true;
    private boolean streaming = false;
    private Map<String, ObjectPool> pools;
    private String connectionFactoryClass = "org.mule.transport.ftp.FtpConnectionFactory";

    public String getProtocol() {
        return FTP;
    }

    public MessageReceiver createReceiver(Service service, InboundEndpoint endpoint) throws Exception {
        List args = this.getReceiverArguments(endpoint.getProperties());
        return this.serviceDescriptor.createMessageReceiver((Connector)this, service, endpoint, args.toArray());
    }

    protected List getReceiverArguments(Map endpointProperties) {
        String tempPolling;
        ArrayList<Long> args = new ArrayList<Long>();
        long polling = this.getPollingFrequency();
        if (endpointProperties != null && (tempPolling = (String)endpointProperties.get(PROPERTY_POLLING_FREQUENCY)) != null) {
            polling = Long.parseLong(tempPolling);
        }
        if (polling <= 0L) {
            polling = 1000L;
        }
        this.logger.debug((Object)("set polling frequency to " + polling));
        args.add(polling);
        return args;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public FTPClient getFtp(EndpointURI uri) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(">>> retrieving client for " + uri));
        }
        return (FTPClient)this.getFtpPool(uri).borrowObject();
    }

    public void releaseFtp(EndpointURI uri, FTPClient client) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("<<< releasing client for " + uri));
        }
        if (this.dispatcherFactory.isCreateDispatcherPerRequest()) {
            this.destroyFtp(uri, client);
        } else {
            this.getFtpPool(uri).returnObject((Object)client);
        }
    }

    public void destroyFtp(EndpointURI uri, FTPClient client) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("<<< destroying client for " + uri));
        }
        try {
            this.getFtpPool(uri).invalidateObject((Object)client);
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getMessage());
        }
    }

    protected synchronized ObjectPool getFtpPool(EndpointURI uri) {
        String key;
        ObjectPool pool;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("=== get pool for " + uri));
        }
        if ((pool = this.pools.get(key = uri.getUser() + ":" + uri.getPassword() + "@" + uri.getHost() + ":" + uri.getPort())) == null) {
            try {
                FtpConnectionFactory connectionFactory = (FtpConnectionFactory)ClassUtils.instanciateClass((String)this.getConnectionFactoryClass(), (Object[])new Object[]{uri}, ((Object)((Object)this)).getClass());
                pool = new GenericObjectPool((PoolableObjectFactory)connectionFactory);
                ((GenericObjectPool)pool).setTestOnBorrow(this.isValidateConnections());
                this.pools.put(key, pool);
            }
            catch (Exception ex) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Hmm, couldn't instanciate FTP connection factory."), (Throwable)ex);
            }
        }
        return pool;
    }

    protected void doInitialise() throws InitialisationException {
        try {
            Class objectFactoryClass = ClassUtils.loadClass((String)this.connectionFactoryClass, ((Object)((Object)this)).getClass());
            if (!FtpConnectionFactory.class.isAssignableFrom(objectFactoryClass)) {
                throw new InitialisationException(MessageFactory.createStaticMessage((String)"FTP connectionFactoryClass is not an instance of org.mule.transport.ftp.FtpConnectionFactory"), (Initialisable)this);
            }
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.pools = new HashMap<String, ObjectPool>();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Stopping all pools");
        }
        try {
            for (ObjectPool pool : this.pools.values()) {
                pool.close();
            }
        }
        catch (Exception e) {
            throw new ConnectorException(CoreMessages.failedToStop((String)"FTP Connector"), (Connector)this, (Throwable)e);
        }
        finally {
            this.pools.clear();
        }
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public FilenameParser getFilenameParser() {
        return this.filenameParser;
    }

    public void setFilenameParser(FilenameParser filenameParser) {
        this.filenameParser = filenameParser;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public void enterActiveOrPassiveMode(FTPClient client, ImmutableEndpoint endpoint) {
        String passiveString = (String)endpoint.getProperty((Object)PROPERTY_PASSIVE_MODE);
        if (passiveString == null) {
            if (this.isPassive()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Entering FTP passive mode");
                }
                client.enterLocalPassiveMode();
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Entering FTP active mode");
                }
                client.enterLocalActiveMode();
            }
        } else {
            boolean passiveMode = Boolean.valueOf(passiveString);
            if (passiveMode) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Entering FTP passive mode (endpoint override)");
                }
                client.enterLocalPassiveMode();
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Entering FTP active mode (endpoint override)");
                }
                client.enterLocalActiveMode();
            }
        }
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setupFileType(FTPClient client, ImmutableEndpoint endpoint) throws Exception {
        int type;
        String binaryTransferString = (String)endpoint.getProperty((Object)PROPERTY_BINARY_TRANSFER);
        if (binaryTransferString == null) {
            if (this.isBinary()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Using FTP BINARY type");
                }
                type = 2;
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Using FTP ASCII type");
                }
                type = 0;
            }
        } else {
            boolean binaryTransfer = Boolean.valueOf(binaryTransferString);
            if (binaryTransfer) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Using FTP BINARY type (endpoint override)");
                }
                type = 2;
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Using FTP ASCII type (endpoint override)");
                }
                type = 0;
            }
        }
        client.setFileType(type);
    }

    public OutputStream getOutputStream(ImmutableEndpoint endpoint, MuleMessage message) throws MuleException {
        try {
            FTPClient client;
            final EndpointURI uri = endpoint.getEndpointURI();
            String filename = this.getFilename(endpoint, message);
            try {
                client = this.createFtpClient(endpoint);
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e, (Object)this);
            }
            try {
                OutputStream out = client.storeFileStream(filename);
                return new CallbackOutputStream(out, new CallbackOutputStream.Callback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClose() throws Exception {
                        try {
                            if (!client.completePendingCommand()) {
                                client.logout();
                                client.disconnect();
                                throw new IOException("FTP Stream failed to complete pending request");
                            }
                        }
                        finally {
                            FtpConnector.this.releaseFtp(uri, client);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.logger.debug((Object)"Error getting output stream: ", (Throwable)e);
                this.releaseFtp(uri, client);
                throw e;
            }
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.streamingFailedNoStream(), message, endpoint, (Throwable)e);
        }
    }

    private String getFilename(ImmutableEndpoint endpoint, MuleMessage message) throws IOException {
        String filename = (String)message.getProperty(PROPERTY_FILENAME);
        String outPattern = (String)endpoint.getProperty((Object)PROPERTY_OUTPUT_PATTERN);
        if (outPattern == null) {
            outPattern = message.getStringProperty(PROPERTY_OUTPUT_PATTERN, this.getOutputPattern());
        }
        if (outPattern != null || filename == null) {
            filename = this.generateFilename(message, outPattern);
        }
        if (filename == null) {
            throw new IOException("Filename is null");
        }
        return filename;
    }

    private String generateFilename(MuleMessage message, String pattern) {
        if (pattern == null) {
            pattern = this.getOutputPattern();
        }
        return this.getFilenameParser().getFilename((MessageAdapter)message, pattern);
    }

    protected FTPClient createFtpClient(ImmutableEndpoint endpoint) throws Exception {
        EndpointURI uri = endpoint.getEndpointURI();
        FTPClient client = this.getFtp(uri);
        this.enterActiveOrPassiveMode(client, endpoint);
        this.setupFileType(client, endpoint);
        String path = uri.getPath();
        if (path.length() >= 2 && path.charAt(1) == '~') {
            path = path.substring(1);
        }
        if (!client.changeWorkingDirectory(path)) {
            throw new IOException(MessageFormat.format("Failed to change working directory to {0}. Ftp error: {1}", path, new Integer(client.getReplyCode())));
        }
        return client;
    }

    protected boolean validateFile(FTPFile file) {
        return true;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }
}

