/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.ftp.FtpConnector;

public class FtpMessageRequester
extends AbstractMessageRequester {
    protected final FtpConnector connector;

    public FtpMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (FtpConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        try {
            EndpointURI uri = this.endpoint.getEndpointURI();
            FTPClient client = this.connector.getFtp(uri);
            this.connector.destroyFtp(uri, client);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleMessage doRequest(long timeout) throws Exception {
        FTPClient client = null;
        try {
            client = this.connector.createFtpClient(this.endpoint);
            FilenameFilter filenameFilter = null;
            if (this.endpoint.getFilter() instanceof FilenameFilter) {
                filenameFilter = (FilenameFilter)this.endpoint.getFilter();
            }
            FTPFile[] files = client.listFiles();
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new IOException("Ftp error: " + client.getReplyCode());
            }
            if (files == null || files.length == 0) {
                MuleMessage muleMessage = null;
                return muleMessage;
            }
            ArrayList<FTPFile> fileList = new ArrayList<FTPFile>();
            FTPFile file = null;
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                if (!file.isFile() || filenameFilter != null && !filenameFilter.accept(null, file.getName()) || !this.connector.validateFile(file)) continue;
                fileList.add(file);
                break;
            }
            if (fileList.size() == 0) {
                MuleMessage i = null;
                return i;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!client.retrieveFile(file.getName(), (OutputStream)baos)) {
                throw new IOException("Ftp error: " + client.getReplyCode());
            }
            DefaultMuleMessage reply = new DefaultMuleMessage((Object)this.connector.getMessageAdapter(baos.toByteArray()));
            reply.setProperty("originalFilename", (Object)file.getName());
            reply.setProperty("fileSize", (Object)new Long(file.getSize()));
            DefaultMuleMessage defaultMuleMessage = reply;
            return defaultMuleMessage;
        }
        finally {
            this.logger.debug((Object)"leaving doRequest()");
            this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
        }
    }
}

