/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.acegisecurity.ui.AuthenticationDetailsSource;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;
import org.acegisecurity.ui.rememberme.NullRememberMeServices;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.ui.savedrequest.SavedRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public abstract class AbstractProcessingFilter
implements Filter,
InitializingBean,
ApplicationEventPublisherAware,
MessageSourceAware {
    public static final String ACEGI_SAVED_REQUEST_KEY = "ACEGI_SAVED_REQUEST_KEY";
    public static final String ACEGI_SECURITY_LAST_EXCEPTION_KEY = "ACEGI_SECURITY_LAST_EXCEPTION";
    protected ApplicationEventPublisher eventPublisher;
    protected AuthenticationDetailsSource authenticationDetailsSource = new AuthenticationDetailsSourceImpl();
    private AuthenticationManager authenticationManager;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private Properties exceptionMappings = new Properties();
    private RememberMeServices rememberMeServices = new NullRememberMeServices();
    private String authenticationFailureUrl;
    private String defaultTargetUrl;
    private String filterProcessesUrl = this.getDefaultFilterProcessesUrl();
    private boolean alwaysUseDefaultTargetUrl = false;
    private boolean continueChainBeforeSuccessfulAuthentication = false;
    private int bufferSize = 8192;
    private boolean useRelativeContext = false;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.filterProcessesUrl, (String)"filterProcessesUrl must be specified");
        Assert.hasLength((String)this.defaultTargetUrl, (String)"defaultTargetUrl must be specified");
        Assert.hasLength((String)this.authenticationFailureUrl, (String)"authenticationFailureUrl must be specified");
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
        Assert.notNull((Object)this.rememberMeServices);
    }

    public abstract Authentication attemptAuthentication(HttpServletRequest var1) throws AuthenticationException;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requiresAuthentication(httpRequest, httpResponse)) {
            Authentication authResult;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Request is to process authentication");
            }
            try {
                this.onPreAuthentication(httpRequest, httpResponse);
                authResult = this.attemptAuthentication(httpRequest);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(httpRequest, httpResponse, failed);
                return;
            }
            if (this.continueChainBeforeSuccessfulAuthentication) {
                chain.doFilter(request, response);
            }
            this.successfulAuthentication(httpRequest, httpResponse, authResult);
            return;
        }
        chain.doFilter(request, response);
    }

    public String getAuthenticationFailureUrl() {
        return this.authenticationFailureUrl;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public abstract String getDefaultFilterProcessesUrl();

    public String getDefaultTargetUrl() {
        return this.defaultTargetUrl;
    }

    public Properties getExceptionMappings() {
        return new Properties(this.exceptionMappings);
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public boolean isAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    public boolean isContinueChainBeforeSuccessfulAuthentication() {
        return this.continueChainBeforeSuccessfulAuthentication;
    }

    public static String obtainFullRequestUrl(HttpServletRequest request) {
        SavedRequest savedRequest = (SavedRequest)request.getSession().getAttribute(ACEGI_SAVED_REQUEST_KEY);
        return savedRequest == null ? null : savedRequest.getFullRequestUrl();
    }

    protected void onPreAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            return uri.endsWith(this.filterProcessesUrl);
        }
        return uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        String finalUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            finalUrl = this.useRelativeContext ? url : request.getContextPath() + url;
        } else if (this.useRelativeContext) {
            int len = request.getContextPath().length();
            int index = url.indexOf(request.getContextPath()) + len;
            finalUrl = url.substring(index);
            if (finalUrl.length() > 1 && finalUrl.charAt(0) == '/') {
                finalUrl = finalUrl.substring(1);
            }
        } else {
            finalUrl = url;
        }
        Assert.isTrue((!response.isCommitted() ? 1 : 0) != 0, (String)"Response already committed; the authentication mechanism must be able to modify buffer size");
        response.setBufferSize(this.bufferSize);
        response.sendRedirect(response.encodeRedirectURL(finalUrl));
    }

    public void setAlwaysUseDefaultTargetUrl(boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationFailureUrl(String authenticationFailureUrl) {
        this.authenticationFailureUrl = authenticationFailureUrl;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setContinueChainBeforeSuccessfulAuthentication(boolean continueChainBeforeSuccessfulAuthentication) {
        this.continueChainBeforeSuccessfulAuthentication = continueChainBeforeSuccessfulAuthentication;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        Assert.isTrue((boolean)(defaultTargetUrl.startsWith("/") | defaultTargetUrl.startsWith("http")), (String)"defaultTarget must start with '/' or with 'http(s)'");
        this.defaultTargetUrl = defaultTargetUrl;
    }

    public void setExceptionMappings(Properties exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updated SecurityContextHolder to contain the following Authentication: '" + authResult + "'"));
        }
        String targetUrl = this.determineTargetUrl(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirecting to target URL from HTTP Session (or default): " + targetUrl));
        }
        this.onSuccessfulAuthentication(request, response, authResult);
        this.rememberMeServices.loginSuccess(request, response, authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, this.getClass()));
        }
        this.sendRedirect(request, response, targetUrl);
    }

    protected String determineTargetUrl(HttpServletRequest request) {
        String targetUrl;
        String string = targetUrl = this.alwaysUseDefaultTargetUrl ? null : AbstractProcessingFilter.obtainFullRequestUrl(request);
        if (targetUrl == null) {
            targetUrl = this.getDefaultTargetUrl();
        }
        return targetUrl;
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Updated SecurityContextHolder to contain null Authentication");
        }
        String failureUrl = this.determineFailureUrl(request, failed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication request failed: " + failed.toString()));
        }
        try {
            request.getSession().setAttribute(ACEGI_SECURITY_LAST_EXCEPTION_KEY, (Object)failed);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.onUnsuccessfulAuthentication(request, response, failed);
        this.rememberMeServices.loginFail(request, response);
        this.sendRedirect(request, response, failureUrl);
    }

    protected String determineFailureUrl(HttpServletRequest request, AuthenticationException failed) {
        return this.exceptionMappings.getProperty(((Object)((Object)failed)).getClass().getName(), this.authenticationFailureUrl);
    }

    public AuthenticationDetailsSource getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setUseRelativeContext(boolean useRelativeContext) {
        this.useRelativeContext = useRelativeContext;
    }
}

