/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.servlet.ServletConnector;
import org.mule.transport.servlet.i18n.ServletMessages;
import org.mule.transport.servlet.jetty.JettyHttpConnector;
import org.mule.util.StringUtils;

public class JettyHttpMessageReceiver
extends AbstractMessageReceiver {
    public static final String JETTY_SERVLET_CONNECTOR_NAME = "_jettyConnector";

    public JettyHttpMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        if ("rest".equals(endpoint.getEndpointURI().getScheme())) {
            ServletConnector scon = (ServletConnector)RegistryContext.getRegistry().lookupConnector(JETTY_SERVLET_CONNECTOR_NAME);
            if (scon != null) {
                throw new CreateException(ServletMessages.noServletConnectorFound((String)JETTY_SERVLET_CONNECTOR_NAME), (Object)this);
            }
            scon = new ServletConnector();
            scon.setName(JETTY_SERVLET_CONNECTOR_NAME);
            scon.setServletUrl(endpoint.getEndpointURI().getAddress());
            try {
                MuleContext muleContext = MuleServer.getMuleContext();
                scon.setMuleContext(muleContext);
                muleContext.getRegistry().registerConnector((Connector)scon);
                String path = endpoint.getEndpointURI().getPath();
                if (StringUtils.isEmpty((String)path)) {
                    path = "/";
                }
                EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("servlet://" + path.substring(1), connector.getMuleContext());
                endpointBuilder.setTransformers(endpoint.getTransformers());
                InboundEndpoint ep = connector.getMuleContext().getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointBuilder);
                scon.registerListener(service, ep);
            }
            catch (Exception e) {
                throw new CreateException(e, (Object)this);
            }
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    protected void doStart() throws MuleException {
        try {
            ((JettyHttpConnector)this.connector).registerListener(this);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart("Jetty Http Receiver"), e, this);
        }
    }

    protected void doStop() throws MuleException {
        try {
            ((JettyHttpConnector)this.connector).unregisterListener(this);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStop("Jetty Http Receiver"), e, this);
        }
    }
}

