/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import org.mule.api.MessagingException;
import org.mule.transport.email.MailUtils;
import org.mule.transport.email.SimpleMailMessageAdapter;

public class MailMessageAdapter
extends SimpleMailMessageAdapter {
    private static final long serialVersionUID = -6013198455030918360L;
    public static final String ATTACHMENT_HEADERS_PROPERTY_POSTFIX = "Headers";

    public MailMessageAdapter(Object object) throws MessagingException {
        super(object);
    }

    protected void handleMessage(Message message) throws Exception {
        Object content = message.getContent();
        if (content instanceof Multipart) {
            TreeMap attachments = new TreeMap();
            MailUtils.getAttachments((Multipart)content, attachments);
            logger.debug((Object)"Received Multipart message. Adding attachments");
            for (Map.Entry entry : attachments.entrySet()) {
                Part part = (Part)entry.getValue();
                String name = entry.getKey().toString();
                this.addAttachment(name, part.getDataHandler());
                this.addAttachmentHeaders(name, part);
            }
        }
        this.setMessage((Part)message);
    }

    protected void addAttachmentHeaders(String name, Part part) throws javax.mail.MessagingException {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        Enumeration e = part.getAllHeaders();
        while (e.hasMoreElements()) {
            Header h = (Header)e.nextElement();
            headers.put(h.getName(), h.getValue());
        }
        if (headers.size() > 0) {
            this.setProperty(name + ATTACHMENT_HEADERS_PROPERTY_POSTFIX, headers);
        }
    }
}

