/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.mule.DefaultMuleMessage;
import org.mule.MuleServer;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ReceiveException;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.email.AbstractRetrieveMailConnector;
import org.mule.transport.email.SessionDetails;
import org.mule.transport.email.i18n.EmailMessages;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class RetrieveMessageReceiver
extends AbstractPollingMessageReceiver
implements MessageCountListener,
Startable,
Stoppable {
    private Folder folder = null;
    private boolean backupEnabled;
    private String backupFolder = null;

    public RetrieveMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint, long checkFrequency, boolean backupEnabled, String backupFolder) throws CreateException {
        super(connector, service, endpoint);
        this.backupFolder = backupFolder;
        this.backupEnabled = backupEnabled;
        this.setFrequency(checkFrequency);
    }

    private AbstractRetrieveMailConnector castConnector() {
        return (AbstractRetrieveMailConnector)this.getConnector();
    }

    protected void doConnect() throws Exception {
        SessionDetails session = this.castConnector().getSessionDetails(this.endpoint);
        Store store = session.newStore();
        store.connect();
        this.folder = store.getFolder(this.castConnector().getMailboxFolder());
        if (StringUtils.isEmpty((String)this.backupFolder)) {
            this.backupFolder = MuleServer.getMuleContext().getConfiguration().getWorkingDirectory() + "/mail/" + this.folder.getName();
        }
        if (this.backupFolder != null && !this.backupFolder.endsWith(File.separator)) {
            this.backupFolder = this.backupFolder + File.separator;
        }
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStop() {
        if (this.folder != null) {
            this.folder.removeMessageCountListener((MessageCountListener)this);
        }
    }

    protected void doStart() throws MuleException {
        super.doStart();
        this.folder.addMessageCountListener((MessageCountListener)this);
    }

    public void messagesAdded(MessageCountEvent event) {
        Message[] messages = event.getMessages();
        if (messages != null) {
            DefaultMuleMessage message = null;
            for (int i = 0; i < messages.length; ++i) {
                try {
                    if (messages[i].getFlags().contains(Flags.Flag.DELETED)) continue;
                    MimeMessage mimeMessage = new MimeMessage((MimeMessage)messages[i]);
                    this.storeMessage((Message)mimeMessage);
                    message = new DefaultMuleMessage((Object)this.castConnector().getMessageAdapter(mimeMessage));
                    if (this.castConnector().isDeleteReadMessages()) {
                        messages[i].setFlag(Flags.Flag.DELETED, true);
                    } else {
                        messages[i].setFlag(Flags.Flag.SEEN, true);
                    }
                    this.routeMessage((MuleMessage)message, this.endpoint.isSynchronous());
                    continue;
                }
                catch (MuleException e) {
                    this.handleException((Exception)((Object)e));
                    continue;
                }
                catch (Exception e) {
                    Object forwarded = message != null ? new RoutingException(EmailMessages.routingError(), message, this.endpoint, (Throwable)e) : new ReceiveException(this.endpoint, -1L, (Throwable)e);
                    this.handleException((Exception)forwarded);
                }
            }
        }
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        super.handleUnacceptedFilter(message);
        if (message.getPayload() instanceof Message) {
            Message msg = (Message)message.getPayload();
            try {
                msg.setFlag(Flags.Flag.DELETED, this.endpoint.isDeleteUnacceptedMessages());
            }
            catch (MessagingException e) {
                this.logger.error((Object)("failed to set message deleted: " + e.getMessage()), (Throwable)e);
            }
        }
        return message;
    }

    public void messagesRemoved(MessageCountEvent event) {
        if (this.logger.isDebugEnabled()) {
            Message[] messages = event.getMessages();
            for (int i = 0; i < messages.length; ++i) {
                try {
                    this.logger.debug((Object)("Message removed: " + messages[i].getSubject()));
                    continue;
                }
                catch (MessagingException ignore) {
                    this.logger.debug((Object)("ignoring exception: " + ignore.getMessage()));
                }
            }
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFolder(Folder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Mail folder cannot be null");
        }
        Folder folder2 = this.folder = folder;
        synchronized (folder2) {
            if (!this.folder.isOpen()) {
                try {
                    this.folder.open(2);
                }
                catch (MessagingException e) {
                    this.logger.warn((Object)("Failed to open folder: " + folder.getFullName()), (Throwable)e);
                }
            }
        }
    }

    protected void storeMessage(Message msg) throws IOException, MessagingException {
        if (this.backupEnabled) {
            String filename = msg.getFileName();
            if (filename == null) {
                Address[] from = msg.getFrom();
                filename = from != null && from.length > 0 ? (from[0] instanceof InternetAddress ? ((InternetAddress)from[0]).getAddress() : from[0].toString()) : "(no from address)";
                filename = filename + "[" + UUID.getUUID() + "]";
            }
            filename = FileUtils.prepareWinFilename((String)filename);
            filename = this.backupFolder + filename + ".msg";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Writing message to: " + filename));
            }
            File f = FileUtils.createFile((String)filename);
            FileOutputStream fos = new FileOutputStream(f);
            msg.writeTo((OutputStream)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void poll() {
        try {
            block17: {
                try {
                    if (!this.folder.isOpen()) {
                        this.folder.open(2);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block17;
                    this.logger.debug((Object)("ignoring exception: " + e.getMessage()));
                }
            }
            int count = this.folder.getMessageCount();
            if (count > 0) {
                Message[] messages = this.folder.getMessages();
                MessageCountEvent event = new MessageCountEvent(this.folder, 1, true, messages);
                this.messagesAdded(event);
            } else if (count == -1) {
                throw new MessagingException("Cannot monitor folder: " + this.folder.getFullName() + " as folder is closed");
            }
        }
        catch (MessagingException e) {
            this.handleException((Exception)((Object)e));
        }
        finally {
            try {
                this.folder.close(true);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to close pop3  inbox: " + e.getMessage()));
            }
        }
    }

    protected void doDispose() {
        if (null != this.folder) {
            this.folder.removeMessageCountListener((MessageCountListener)this);
            if (this.folder.isOpen()) {
                try {
                    this.folder.close(true);
                }
                catch (Exception e) {
                    this.logger.debug((Object)("ignoring exception: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

