/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.TransactionTemplate;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.vm.VMConnector;
import org.mule.transport.vm.VMMessageReceiver;
import org.mule.transport.vm.i18n.VMMessages;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageDispatcher
extends AbstractMessageDispatcher {
    private final VMConnector connector;

    public VMMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (VMConnector)endpoint.getConnector();
    }

    protected void doDispatch(final MuleEvent event) throws Exception {
        EndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        event.transformMessage();
        if (endpointUri == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Endpoint"), event.getMessage(), event.getEndpoint());
        }
        if (this.connector.isQueueEvents()) {
            QueueSession session = this.connector.getQueueSession();
            Queue queue = session.getQueue(endpointUri.getAddress());
            queue.put(event.getMessage());
        } else {
            final VMMessageReceiver receiver = this.connector.getReceiver(event.getEndpoint().getEndpointURI());
            if (receiver == null) {
                this.logger.warn((Object)("No receiver for endpointUri: " + event.getEndpoint().getEndpointURI()));
                return;
            }
            MuleMessage message = event.getMessage();
            this.connector.getSessionHandler().storeSessionInfoToMessage(event.getSession(), message);
            TransactionTemplate tt = new TransactionTemplate(receiver.getEndpoint().getTransactionConfig(), this.connector.getExceptionListener(), event.getMuleContext());
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    receiver.onMessage(event.getMessage());
                    return null;
                }
            };
            tt.execute(cb);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("dispatched MuleEvent on endpointUri: " + endpointUri));
        }
    }

    protected MuleMessage doSend(final MuleEvent event) throws Exception {
        EndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        final VMMessageReceiver receiver = this.connector.getReceiver(endpointUri);
        event.transformMessage();
        if (receiver == null) {
            if (this.connector.isQueueEvents()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Writing to queue as there is no receiver on connector: " + this.connector.getName() + ", for endpointUri: " + event.getEndpoint().getEndpointURI()));
                }
                this.doDispatch(event);
                return null;
            }
            throw new NoReceiverForEndpointException(VMMessages.noReceiverForEndpoint(this.connector.getName(), event.getEndpoint().getEndpointURI()));
        }
        MuleMessage message = event.getMessage();
        this.connector.getSessionHandler().storeSessionInfoToMessage(event.getSession(), message);
        TransactionTemplate tt = new TransactionTemplate(receiver.getEndpoint().getTransactionConfig(), this.connector.getExceptionListener(), event.getMuleContext());
        TransactionCallback cb = new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                return receiver.onCall(event.getMessage(), true);
            }
        };
        MuleMessage retMessage = (MuleMessage)tt.execute(cb);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sent event on endpointUri: " + event.getEndpoint().getEndpointURI()));
        }
        return retMessage;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        if (this.connector.isQueueEvents()) {
            this.connector.getQueueProfile().configureQueue(this.endpoint.getEndpointURI().getAddress(), this.connector.getQueueManager());
        }
    }

    protected void doDisconnect() throws Exception {
    }
}

