/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.AbstractXStreamTransformer;
import org.mule.module.xml.transformer.DomDocumentToXml;

public class XmlToObject
extends AbstractXStreamTransformer {
    private final DomDocumentToXml domTransformer = new DomDocumentToXml();

    public XmlToObject() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Document.class);
        this.setReturnClass(Object.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object src = message.getPayload();
        if (src instanceof byte[]) {
            try {
                InputStreamReader xml = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])src), outputEncoding);
                return this.getXStream().fromXML((Reader)xml);
            }
            catch (UnsupportedEncodingException uee) {
                throw new TransformerException(this, (Throwable)uee);
            }
        }
        if (src instanceof InputStream) {
            InputStream input = (InputStream)src;
            try {
                InputStreamReader xml = new InputStreamReader(input, outputEncoding);
                Object object = this.getXStream().fromXML((Reader)xml);
                return object;
            }
            catch (UnsupportedEncodingException uee) {
                throw new TransformerException(this, (Throwable)uee);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)"Exception closing stream: ", (Throwable)e);
                }
            }
        }
        if (src instanceof String) {
            return this.getXStream().fromXML(src.toString());
        }
        return this.getXStream().fromXML((String)this.domTransformer.transform(src));
    }
}

