/*
 * $Id: RetryPolicy.java 13089 2008-10-17 00:19:24Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.retry;

import org.mule.retry.PolicyStatus;

/**
 * A RetryPolicy takes some action each time an exception occurs and returns a {@link PolicyStatus}
 * which indicates whether the policy is exhausted or should continue to retry.  
 */
public interface RetryPolicy
{
    public PolicyStatus applyPolicy(Throwable cause);
}
