/*
 * $Id: DirectService.java 12790 2008-09-29 05:54:35Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.model.direct;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.service.ServiceException;
import org.mule.service.AbstractService;

/**
 * A direct service invokes the service service directly without any threading, even
 * when the invocation is asynchronous
 */
public class DirectService extends AbstractService
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = -8590955440156945732L;

    public DirectService()
    {
        super();
    }

    protected MuleMessage doSend(MuleEvent event) throws MuleException
    {
        return invokeComponent(event);
    }

    protected void doDispatch(MuleEvent event) throws MuleException
    {
        try
        {
            waitIfPaused(event);
        }
        catch (InterruptedException e)
        {
            throw new ServiceException(event.getMessage(), this, e);
        }
        invokeComponent(event);
    }

}
