/*
 * $Id: Kiwi.java 14767 2009-05-23 15:19:32Z rossmason $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tck.testmodels.fruit;

import org.mule.api.MuleEventContext;

/**
 * A test object not implementing Callable, but having a matching method accepting
 * MuleEventContext.
 */
public class Kiwi implements Fruit
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = -1468423665948468954L;

    private boolean bitten;

    public void handle(MuleEventContext eventContext) throws Exception
    {
        final Object payload = eventContext.transformMessage();
        if (payload instanceof FruitLover)
        {
            this.bite();
        }
    }

    public void bite()
    {
        this.bitten = true;
    }

    public boolean isBitten()
    {
        return this.bitten;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (!(o instanceof Kiwi))
        {
            return false;
        }

        Kiwi kiwi = (Kiwi) o;

        if (bitten != kiwi.bitten)
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        return (bitten ? 1 : 0);
    }
}
