/*
 * $Id: StreamClosingInterceptor.java 13745 2009-01-19 23:15:33Z dandiep $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.cxf.support;

import org.mule.module.xml.stax.DelegateXMLStreamReader;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

/**
 * Replaces the original XMLStreamReader with another one which
 * closes the underlying InputStream.
 */
public class StreamClosingInterceptor extends AbstractPhaseInterceptor<Message>
{
    public StreamClosingInterceptor()
    {
        super(Phase.POST_STREAM);
        addAfter(StaxInInterceptor.class.getName());
    }

    public void handleMessage(final Message message) throws Fault
    {
        XMLStreamReader xsr = message.getContent(XMLStreamReader.class);
        final InputStream is = message.getContent(InputStream.class);
        DelegateXMLStreamReader xsr2 = new DelegateXMLStreamReader(xsr) {

            @Override
            public void close() throws XMLStreamException
            {
                super.close();
                try
                {
                    is.close();
                }
                catch (IOException e)
                {
                    throw new XMLStreamException(e);
                }
            }
        };
        message.setContent(XMLStreamReader.class, xsr2);
    }
}

