/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.AbstractList;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayQueue<E>
extends AbstractList<E>
implements Queue<E> {
    private Object[] _elements;
    private int _nextE;
    private int _nextSlot;
    private int _size;
    private int _growCapacity;

    public ArrayQueue() {
        this._elements = new Object[64];
        this._growCapacity = 32;
    }

    public ArrayQueue(int capacity) {
        this._elements = new Object[capacity];
        this._growCapacity = -1;
    }

    public ArrayQueue(int initCapacity, int growBy) {
        this._elements = new Object[initCapacity];
        this._growCapacity = growBy;
    }

    @Override
    public synchronized boolean add(E e) {
        ++this._size;
        this._elements[this._nextSlot++] = e;
        if (this._nextSlot == this._elements.length) {
            this._nextSlot = 0;
        }
        if (this._nextSlot == this._nextE) {
            if (this._growCapacity <= 0) {
                throw new IllegalStateException("Full");
            }
            Object[] elements = new Object[this._elements.length + this._growCapacity];
            int split = this._elements.length - this._nextE;
            if (split > 0) {
                System.arraycopy(this._elements, this._nextE, elements, 0, split);
            }
            if (this._nextE != 0) {
                System.arraycopy(this._elements, 0, elements, split, this._nextSlot);
            }
            this._elements = elements;
            this._nextE = 0;
            this._nextSlot = this._size;
        }
        return true;
    }

    @Override
    public synchronized E element() {
        if (this._nextSlot == this._nextE) {
            throw new NoSuchElementException();
        }
        return (E)this._elements[this._nextE];
    }

    @Override
    public synchronized boolean offer(E e) {
        ++this._size;
        this._elements[this._nextSlot++] = e;
        if (this._nextSlot == this._elements.length) {
            this._nextSlot = 0;
        }
        if (this._nextSlot == this._nextE) {
            if (this._growCapacity <= 0) {
                return false;
            }
            Object[] elements = new Object[this._elements.length + this._growCapacity];
            int split = this._elements.length - this._nextE;
            if (split > 0) {
                System.arraycopy(this._elements, this._nextE, elements, 0, split);
            }
            if (this._nextE != 0) {
                System.arraycopy(this._elements, 0, elements, split, this._nextSlot);
            }
            this._elements = elements;
            this._nextE = 0;
            this._nextSlot = this._size;
        }
        return true;
    }

    @Override
    public synchronized E peek() {
        if (this._nextSlot == this._nextE) {
            return null;
        }
        return (E)this._elements[this._nextE];
    }

    @Override
    public synchronized E poll() {
        if (this._size == 0) {
            return null;
        }
        Object e = this._elements[this._nextE];
        this._elements[this._nextE] = null;
        --this._size;
        if (++this._nextE == this._elements.length) {
            this._nextE = 0;
        }
        return (E)e;
    }

    @Override
    public synchronized E remove() {
        if (this._nextSlot == this._nextE) {
            throw new NoSuchElementException();
        }
        Object e = this._elements[this._nextE++];
        if (this._nextE == this._elements.length) {
            this._nextE = 0;
        }
        return (E)e;
    }

    @Override
    public synchronized void clear() {
        this._size = 0;
        this._nextE = 0;
        this._nextSlot = 0;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public synchronized E get(int index) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException(index + ">=" + this._size);
        }
        int i = this._nextE + index;
        if (i >= this._elements.length) {
            i -= this._elements.length;
        }
        return (E)this._elements[i];
    }
}

