/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.collection;

import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.util.SpringXMLUtils;
import org.springframework.beans.factory.config.MapFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AttributeMapDefinitionParser
extends ChildDefinitionParser {
    public AttributeMapDefinitionParser(String setter) {
        super(setter, ManagedMap.class);
    }

    protected Class getBeanClass(Element element) {
        return MapFactoryBean.class;
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedMap values = new ManagedMap();
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String oldName = SpringXMLUtils.attributeName(attribute);
            String name = this.beanPropertyConfiguration.translateName(oldName);
            Object value = this.beanPropertyConfiguration.translateValue(oldName, attribute.getNodeValue());
            if (this.beanPropertyConfiguration.isReference(oldName)) {
                values.put((Object)name, (Object)new RuntimeBeanReference(attribute.getNodeValue()));
                continue;
            }
            values.put((Object)name, value);
        }
        builder.addPropertyValue("sourceMap", (Object)values);
        builder.addPropertyValue("targetMapClass", (Object)super.getBeanClass(element));
        this.postProcess(parserContext, this.getBeanAssembler(element, builder), element);
    }
}

