/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.processors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class CheckExclusiveAttributes
implements PreProcessor {
    public static final int NONE = -1;
    private Map knownAttributes = new HashMap();

    public CheckExclusiveAttributes(String[][] attributeSets) {
        for (int set = 0; set < attributeSets.length; ++set) {
            String[] attributes = attributeSets[set];
            for (int attribute = 0; attribute < attributes.length; ++attribute) {
                this.knownAttributes.put(attributes[attribute], new Integer(set));
            }
        }
    }

    public void preProcess(PropertyConfiguration config, Element element) {
        LinkedList<String> foundAttributes = new LinkedList<String>();
        int foundSetIndex = -1;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String alias = SpringXMLUtils.attributeName((Attr)attributes.item(i));
            if (!this.knownAttributes.containsKey(alias)) continue;
            int index = (Integer)this.knownAttributes.get(alias);
            if (foundSetIndex != -1 && foundSetIndex != index) {
                StringBuffer message = new StringBuffer("The attribute '");
                message.append(alias);
                message.append("' cannot appear with the attribute");
                if (foundAttributes.size() > 1) {
                    message.append("s");
                }
                Iterator found = foundAttributes.iterator();
                while (found.hasNext()) {
                    message.append(" '");
                    message.append(found.next());
                    message.append("'");
                }
                message.append(" in element ");
                message.append(SpringXMLUtils.elementToString(element));
                message.append(".");
                throw new CheckExclusiveAttributesException(message.toString());
            }
            foundSetIndex = index;
            foundAttributes.add(alias);
        }
    }

    public static class CheckExclusiveAttributesException
    extends IllegalStateException {
        private CheckExclusiveAttributesException(String message) {
            super(message);
        }
    }
}

