/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.mule.api.MessagingException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.MessageAdapter;
import org.mule.transformer.simple.SerializableToByteArray;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.soap.MuleSoapHeaders;
import org.mule.transport.soap.i18n.SoapMessages;
import org.mule.util.StringUtils;

public class AxisMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -923205879581370143L;
    private final Object payload;
    private final SOAPMessage soapMessage;
    private Transformer trans;

    public AxisMessageAdapter(Object message) throws MessagingException {
        block10: {
            this.trans = new SerializableToByteArray();
            this.payload = message;
            try {
                MessageContext ctx = MessageContext.getCurrentContext();
                if (ctx != null) {
                    MuleSoapHeaders header = new MuleSoapHeaders(ctx.getMessage().getSOAPPart().getEnvelope().getHeader());
                    if (StringUtils.isNotBlank((String)header.getReplyTo())) {
                        this.setReplyTo(header.getReplyTo());
                    }
                    if (StringUtils.isNotBlank((String)header.getCorrelationGroup())) {
                        this.setCorrelationGroupSize(Integer.parseInt(header.getCorrelationGroup()));
                    }
                    if (StringUtils.isNotBlank((String)header.getCorrelationSequence())) {
                        this.setCorrelationSequence(Integer.parseInt(header.getCorrelationSequence()));
                    }
                    if (StringUtils.isNotBlank((String)header.getCorrelationId())) {
                        this.setCorrelationId(header.getCorrelationId());
                    }
                    this.soapMessage = ctx.getMessage();
                    int x = 1;
                    try {
                        Iterator i = this.soapMessage.getAttachments();
                        while (i.hasNext()) {
                            super.addAttachment(String.valueOf(x), ((AttachmentPart)i.next()).getActivationDataHandler());
                            ++x;
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        logger.fatal((Object)"Failed to read attachments", (Throwable)e);
                        break block10;
                    }
                }
                this.soapMessage = null;
            }
            catch (SOAPException e) {
                throw new MessagingException(SoapMessages.failedToProcessSoapHeaders(), message, (Throwable)e);
            }
        }
    }

    public AxisMessageAdapter(AxisMessageAdapter template) {
        super((MessageAdapter)template);
        this.trans = new SerializableToByteArray();
        this.soapMessage = template.soapMessage;
        this.payload = template.payload;
        this.trans = template.trans;
    }

    public Object getPayload() {
        return this.payload;
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        if (null != this.soapMessage) {
            this.soapMessage.addAttachmentPart((javax.xml.soap.AttachmentPart)new AttachmentPart(dataHandler));
        }
        super.addAttachment(name, dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        if (!"all".equalsIgnoreCase(name)) {
            throw new SOAPException(SoapMessages.cannotRemoveSingleAttachment().toString());
        }
        this.soapMessage.removeAllAttachments();
        this.attachments.clear();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new AxisMessageAdapter(this);
    }
}

