/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.Document;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.util.NamespaceManager;

public abstract class AbstractXPathExpressionEvaluator
implements ExpressionEvaluator,
Disposable,
MuleContextAware {
    private Map cache = new WeakHashMap(8);
    private MuleContext muleContext;
    private NamespaceManager namespaceManager;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.namespaceManager = this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad("NamespaceManager"), (Throwable)e);
        }
    }

    public Object evaluate(String expression, MuleMessage message) {
        try {
            Object payload = message.getPayload();
            if (payload instanceof String) {
                payload = message.getPayload(Document.class);
            }
            XPath xpath = this.getXPath(expression, payload);
            if (this.namespaceManager != null) {
                this.addNamespaces(this.namespaceManager, xpath);
            }
            List result = xpath.selectNodes(payload);
            if ((result = this.extractResultsFromNodes(result)).size() == 1) {
                return result.get(0);
            }
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(expression), (Throwable)e);
        }
    }

    protected void addNamespaces(NamespaceManager manager, XPath xpath) {
        for (Map.Entry entry : manager.getNamespaces().entrySet()) {
            try {
                xpath.addNamespace(entry.getKey().toString(), entry.getValue().toString());
            }
            catch (JaxenException e) {
                throw new ExpressionRuntimeException(XmlMessages.failedToRegisterNamespace(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
    }

    public final void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    protected XPath getXPath(String expression, Object object) throws JaxenException {
        XPath xpath = (XPath)this.cache.get(expression + this.getClass().getName());
        if (xpath == null) {
            xpath = this.createXPath(expression, object);
            this.cache.put(expression + this.getClass().getName(), xpath);
        }
        return xpath;
    }

    protected abstract XPath createXPath(String var1, Object var2) throws JaxenException;

    protected List extractResultsFromNodes(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<Object> newResults = new ArrayList<Object>(results.size());
        for (Object o : results) {
            newResults.add(this.extractResultFromNode(o));
        }
        return newResults;
    }

    public void dispose() {
        this.cache.clear();
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected abstract Object extractResultFromNode(Object var1);
}

