/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.List;
import java.util.Map;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamFactory {
    public static final String XSTREAM_DOM_DRIVER = "com.thoughtworks.xstream.io.xml.DomDriver";
    public static final String XSTREAM_DOM4J_DRIVER = "com.thoughtworks.xstream.io.xml.Dom4JDriver";
    public static final String XSTREAM_JDOM_DRIVER = "com.thoughtworks.xstream.io.xml.JDomDriver";
    public static final String XSTREAM_STAX_DRIVER = "com.thoughtworks.xstream.io.xml.StaxDriver";
    public static final String XSTREAM_XPP_DRIVER = "com.thoughtworks.xstream.io.xml.XppDriver";
    private final XStream xstream;

    public XStreamFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(XSTREAM_XPP_DRIVER, null, null);
    }

    public XStreamFactory(String driverClassName, Map<String, Class> aliases, List<Class> converters) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class driverClass = ClassUtils.loadClass(driverClassName, this.getClass());
        this.xstream = new XStream((HierarchicalStreamDriver)driverClass.newInstance());
        this.xstream.registerConverter((Converter)new ConcurrentHashMapConverter(this.xstream.getMapper()), -1);
        if (aliases != null) {
            for (Map.Entry entry : aliases.entrySet()) {
                this.xstream.alias((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        if (converters != null) {
            for (Class clazz : converters) {
                this.xstream.registerConverter((Converter)clazz.newInstance());
            }
        }
    }

    public final XStream getInstance() {
        return this.xstream;
    }

    private class ConcurrentHashMapConverter
    extends MapConverter {
        public ConcurrentHashMapConverter(Mapper mapper) throws ClassNotFoundException {
            super(mapper);
        }

        public boolean canConvert(Class aClass) {
            String className = aClass.getName();
            return className.equals("java.util.concurrent.ConcurrentHashMap") || className.equals("edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap");
        }
    }
}

