/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool.PoolableObjectFactory;
import org.mule.api.endpoint.EndpointURI;

public class FtpConnectionFactory
implements PoolableObjectFactory {
    private EndpointURI uri;

    public FtpConnectionFactory(EndpointURI uri) {
        this.uri = uri;
    }

    public Object makeObject() throws Exception {
        FTPClient client = new FTPClient();
        if (this.uri.getPort() > 0) {
            client.connect(this.uri.getHost(), this.uri.getPort());
        } else {
            client.connect(this.uri.getHost());
        }
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new IOException("Ftp connect failed: " + client.getReplyCode());
        }
        if (!client.login(this.uri.getUser(), this.uri.getPassword())) {
            throw new IOException("Ftp login failed: " + client.getReplyCode());
        }
        if (!client.setFileType(2)) {
            throw new IOException("Ftp error. Couldn't set BINARY transfer type: " + client.getReplyCode());
        }
        return client;
    }

    public void destroyObject(Object obj) throws Exception {
        FTPClient client = (FTPClient)obj;
        client.logout();
        client.disconnect();
    }

    public boolean validateObject(Object obj) {
        FTPClient client = (FTPClient)obj;
        try {
            client.sendNoOp();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void activateObject(Object obj) throws Exception {
        FTPClient client = (FTPClient)obj;
        client.setReaderThread(true);
    }

    public void passivateObject(Object obj) throws Exception {
        FTPClient client = (FTPClient)obj;
        client.setReaderThread(false);
    }
}

