/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.MuleServer;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.DefaultMessageAdapter;
import org.mule.transport.NullPayload;
import org.mule.transport.cxf.CxfConnector;
import org.mule.transport.cxf.support.DelegatingOutputStream;
import org.mule.transport.cxf.support.MuleProtocolHeadersOutInterceptor;
import org.mule.transport.cxf.transport.MuleUniversalTransport;

public class MuleUniversalConduit
extends AbstractConduit {
    private static final Logger LOGGER = LogUtils.getL7dLogger(MuleUniversalConduit.class);
    private EndpointInfo endpoint;
    private CxfConnector connector;
    private Destination decoupledDestination;
    private String decoupledEndpoint;
    private MuleUniversalTransport transport;
    private int decoupledDestinationRefCount;
    private boolean closeInput;
    private boolean applyTransformersToProtocol;
    private ImmutableEndpoint muleEndpoint;
    private Map<String, OutboundEndpoint> protocolEndpoints = new HashMap<String, OutboundEndpoint>();

    public MuleUniversalConduit(MuleUniversalTransport transport, CxfConnector connector, EndpointInfo ei, EndpointReferenceType t) {
        super(MuleUniversalConduit.getTargetReference(ei, t));
        this.transport = transport;
        this.endpoint = ei;
        this.connector = connector;
    }

    public void close(Message msg) throws IOException {
        InputStream in;
        OutputStream os = (OutputStream)msg.getContent(OutputStream.class);
        if (os != null) {
            os.close();
        }
        if (this.closeInput && (in = (InputStream)msg.getContent(InputStream.class)) != null) {
            in.close();
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public synchronized Destination getBackChannel() {
        if (this.decoupledDestination == null && this.decoupledEndpoint != null) {
            this.setUpDecoupledDestination();
        }
        return this.decoupledDestination;
    }

    protected void setUpDecoupledDestination() {
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(this.decoupledEndpoint);
        try {
            this.decoupledDestination = this.transport.getDestination(ei);
            this.decoupledDestination.setMessageObserver((MessageObserver)new InterposedMessageObserver());
            this.duplicateDecoupledDestination();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void prepare(final Message message) throws IOException {
        final ByteArrayOutputStream cache = new ByteArrayOutputStream();
        final DelegatingOutputStream delegating = new DelegatingOutputStream(cache);
        message.setContent(OutputStream.class, (Object)delegating);
        message.setContent(DelegatingOutputStream.class, (Object)delegating);
        AbstractPhaseInterceptor<Message> i = new AbstractPhaseInterceptor<Message>("pre-stream"){

            public void handleMessage(Message m) throws Fault {
                try {
                    MuleUniversalConduit.this.dispatchMuleMessage(m);
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            }
        };
        i.getAfter().add(MuleProtocolHeadersOutInterceptor.class.getName());
        message.getInterceptorChain().add((Interceptor)i);
        OutputHandler handler = new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                out.write(cache.toByteArray());
                delegating.setOutputStream(out);
                message.getInterceptorChain().doIntercept(message);
            }
        };
        MuleEvent event = (MuleEvent)message.getExchange().get((Object)"MULE_EVENT");
        DefaultMessageAdapter req = event == null ? new DefaultMessageAdapter((Object)handler) : new DefaultMessageAdapter((Object)handler, (MessageAdapter)event.getMessage());
        message.getExchange().put((Object)"mule.message", (Object)req);
    }

    protected void dispatchMuleMessage(Message m) throws IOException {
        String uri = this.setupURL(m);
        LOGGER.info("Sending message to " + uri);
        try {
            OutboundEndpoint protocolEndpoint = this.getProtocolEndpoint(uri);
            MessageAdapter req = (MessageAdapter)m.getExchange().get((Object)"mule.message");
            req.setProperty("MULE_ENDPOINT", (Object)uri, PropertyScope.INVOCATION);
            MuleMessage result = this.sendStream(req, protocolEndpoint, m.getExchange());
            if (result == null) {
                m.getExchange().put((Object)"exchange.finished", (Object)Boolean.TRUE);
                return;
            }
            InputStream is = this.getResponseBody(m, result);
            if (is != null) {
                MessageImpl inMessage = new MessageImpl();
                String contentType = result.getStringProperty("Content-Type", "text/xml");
                inMessage.put((Object)"Content-Type", (Object)contentType);
                inMessage.put((Object)Message.ENCODING, (Object)result.getEncoding());
                inMessage.put((Object)"mule.message", (Object)result);
                inMessage.setContent(InputStream.class, (Object)is);
                inMessage.setExchange(m.getExchange());
                this.getMessageObserver().onMessage((Message)inMessage);
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ex = new IOException("Could not send message to Mule.");
            ex.initCause(e);
            throw ex;
        }
    }

    protected OutboundEndpoint getProtocolEndpoint(String uri) throws MuleException {
        OutboundEndpoint ep = this.protocolEndpoints.get(uri);
        if (ep == null) {
            ep = this.initializeProtocolEndpoint(uri);
        }
        return ep;
    }

    protected synchronized OutboundEndpoint initializeProtocolEndpoint(String uri) throws MuleException {
        OutboundEndpoint ep = this.protocolEndpoints.get(uri);
        if (ep != null) {
            return ep;
        }
        MuleContext muleContext = MuleServer.getMuleContext();
        MuleRegistry registry = muleContext.getRegistry();
        if (this.muleEndpoint == null) {
            return registry.lookupEndpointFactory().getOutboundEndpoint(uri);
        }
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(uri, muleContext);
        String connectorName = (String)this.muleEndpoint.getProperty((Object)"protocolConnector");
        if (connectorName != null) {
            builder.setConnector(registry.lookupConnector(connectorName));
        }
        ep = registry.lookupEndpointFactory().getOutboundEndpoint((EndpointBuilder)builder);
        this.protocolEndpoints.put(uri, ep);
        return ep;
    }

    protected InputStream getResponseBody(Message m, MuleMessage result) throws TransformerException, IOException {
        boolean response;
        boolean bl = response = result != null && !NullPayload.getInstance().equals(result.getPayload()) && !this.isOneway(m.getExchange());
        if (response) {
            InputStream is = (InputStream)result.getPayload(InputStream.class);
            PushbackInputStream pb = new PushbackInputStream(is);
            result.setPayload((Object)pb);
            int b = pb.read();
            if (b != -1) {
                pb.unread(b);
                return pb;
            }
        }
        return null;
    }

    protected boolean isOneway(Exchange exchange) {
        return exchange != null && exchange.isOneWay();
    }

    protected String setupURL(Message message) throws MalformedURLException {
        String result;
        String value = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get((Object)Message.PATH_INFO);
        String queryString = (String)message.get((Object)Message.QUERY_STRING);
        String string = result = value != null ? value : this.getTargetOrEndpoint();
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return result;
    }

    protected String getTargetOrEndpoint() {
        if (this.target != null) {
            return this.target.getAddress().getValue();
        }
        return this.endpoint.getAddress().toString();
    }

    public void onClose(Message m) throws IOException {
    }

    protected MuleMessage sendStream(MessageAdapter sa, OutboundEndpoint ep, Exchange exchange) throws MuleException {
        MuleEvent prev;
        MuleEventContext eventContext = RequestContext.getEventContext();
        MuleSession session = null;
        if (eventContext != null) {
            session = eventContext.getSession();
        }
        DefaultMuleMessage message = new DefaultMuleMessage((Object)sa);
        if (session == null) {
            session = new DefaultMuleSession((MuleMessage)message, this.connector.getSessionHandler(), this.connector.getMuleContext());
        }
        if ((prev = RequestContext.getEvent()) != null) {
            for (String key : prev.getEndpoint().getProperties().keySet()) {
                message.removeProperty(key);
            }
        }
        message.removeProperty("operation");
        message.removeProperty("cxf_operation");
        message.removeProperty("cxf_service");
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)ep, session, true);
        event.setTimeout(Integer.MIN_VALUE);
        RequestContext.setEvent((MuleEvent)event);
        if (this.applyTransformersToProtocol) {
            message.applyTransformers(((OutboundEndpoint)prev.getEndpoint()).getTransformers());
            event.transformMessage();
        }
        MuleMessage msg = ep.send((MuleEvent)event);
        Holder holder = (Holder)exchange.get((Object)"holder");
        if (holder != null) {
            holder.value = msg;
        }
        return msg;
    }

    public void close() {
        if (this.decoupledDestination != null) {
            this.releaseDecoupledDestination();
        }
    }

    protected synchronized void duplicateDecoupledDestination() {
        ++this.decoupledDestinationRefCount;
    }

    protected synchronized void releaseDecoupledDestination() {
        if (--this.decoupledDestinationRefCount == 0) {
            this.decoupledDestination.shutdown();
        }
    }

    public String getDecoupledEndpoint() {
        return this.decoupledEndpoint;
    }

    public void setDecoupledEndpoint(String decoupledEndpoint) {
        this.decoupledEndpoint = decoupledEndpoint;
    }

    protected static EndpointReferenceType getTargetReference(EndpointInfo ei, EndpointReferenceType t) {
        EndpointReferenceType ref = null;
        if (null == t) {
            ref = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(ei.getAddress());
            ref.setAddress(address);
            if (ei.getService() != null) {
                EndpointReferenceUtils.setServiceAndPortName((EndpointReferenceType)ref, (QName)ei.getService().getName(), (String)ei.getName().getLocalPart());
            }
        } else {
            ref = t;
        }
        return ref;
    }

    public void setCloseInput(boolean closeInput) {
        this.closeInput = closeInput;
    }

    public void setApplyTransformersToProtocol(boolean applyTransformersToProtocol) {
        this.applyTransformersToProtocol = applyTransformersToProtocol;
    }

    protected CxfConnector getConnector() {
        return this.connector;
    }

    protected EndpointInfo getEndpoint() {
        return this.endpoint;
    }

    protected MuleUniversalTransport getTransport() {
        return this.transport;
    }

    public void setMuleEndpoint(ImmutableEndpoint muleEndpoint) {
        this.muleEndpoint = muleEndpoint;
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"decoupled.channel.message", (Object)Boolean.TRUE);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)200);
            inMessage.remove((Object)"org.apache.cxf.async.post.response.dispatch");
            MuleUniversalConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

