/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.RequiredValueException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.ExpressionConstants;

public class MessageHeadersListExpressionEvaluator
implements ExpressionEvaluator,
ExpressionConstants {
    public static final String NAME = "headers-list";

    public Object evaluate(String expression, MuleMessage message) {
        ArrayList<Object> result;
        if ("*".equals(expression)) {
            result = new ArrayList<Object>(message.getPropertyNames().size());
            for (String name : message.getPropertyNames()) {
                result.add(message.getProperty(name));
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(expression, ",");
            result = new ArrayList(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                boolean required;
                String s = tokenizer.nextToken();
                if ((s = s.trim()).endsWith("*")) {
                    s = s.substring(0, s.length() - "*".length());
                    required = false;
                } else {
                    required = true;
                }
                Object val = message.getProperty(s);
                if (val != null) {
                    result.add(val);
                    continue;
                }
                if (!required) continue;
                throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }
}

