/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.registry.Registry;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.LifecycleObject;

public class DefaultLifecyclePhase
implements LifecyclePhase {
    protected final transient Log logger = LogFactory.getLog(DefaultLifecyclePhase.class);
    private Class lifecycleClass;
    private Method lifecycleMethod;
    private Set orderedLifecycleObjects = new LinkedHashSet(6);
    private Class[] ignorredObjectTypes;
    private String name;
    private String oppositeLifecyclePhase;
    private Set supportedPhases;

    public DefaultLifecyclePhase(String name, Class lifecycleClass, String oppositeLifecyclePhase) {
        this.name = name;
        this.lifecycleClass = lifecycleClass;
        this.lifecycleMethod = lifecycleClass.getMethods()[0];
        this.oppositeLifecyclePhase = oppositeLifecyclePhase;
    }

    public void applyLifecycle(Registry registry) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying lifecycle phase: " + this.getName()));
        }
        HashSet duplicates = new HashSet();
        for (LifecycleObject lo : this.orderedLifecycleObjects) {
            Collection targetsObj = registry.lookupObjects(lo.getType());
            LinkedList targets = new LinkedList(targetsObj);
            if (targets.size() == 0) continue;
            if (lo.getType().getName().indexOf("Agent") > -1) {
                Collections.sort(targets, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String name1 = o1.getClass().getName();
                        String name2 = o2.getClass().getName();
                        if (name1.indexOf("RmiRegistryAgent") > -1) {
                            return -1;
                        }
                        if (name2.indexOf("RmiRegistryAgent") > -1) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            lo.firePreNotification(MuleServer.getMuleContext());
            Iterator target = targets.iterator();
            while (target.hasNext()) {
                Object o = target.next();
                if (duplicates.contains(o)) {
                    target.remove();
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("lifecycle phase: " + this.getName() + " for object: " + o));
                }
                this.applyLifecycle(o);
                target.remove();
                duplicates.add(o);
            }
            lo.firePostNotification(MuleServer.getMuleContext());
        }
    }

    protected List sortLifecycleInstances(Collection objects, LifecycleObject lo) {
        return new ArrayList(objects);
    }

    public void addOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.add(lco);
    }

    public void removeOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.remove(lco);
    }

    protected boolean ignoreType(Class type) {
        if (this.ignorredObjectTypes == null) {
            return false;
        }
        for (int i = 0; i < this.ignorredObjectTypes.length; ++i) {
            Class ignorredObjectType = this.ignorredObjectTypes[i];
            if (!ignorredObjectType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public Set getOrderedLifecycleObjects() {
        return this.orderedLifecycleObjects;
    }

    public void setOrderedLifecycleObjects(Set orderedLifecycleObjects) {
        this.orderedLifecycleObjects = orderedLifecycleObjects;
    }

    public Class[] getIgnoredObjectTypes() {
        return this.ignorredObjectTypes;
    }

    public void setIgnoredObjectTypes(Class[] ignorredObjectTypes) {
        this.ignorredObjectTypes = ignorredObjectTypes;
    }

    public Class getLifecycleClass() {
        return this.lifecycleClass;
    }

    public void setLifecycleClass(Class lifecycleClass) {
        this.lifecycleClass = lifecycleClass;
    }

    public String getName() {
        return this.name;
    }

    public Set getSupportedPhases() {
        return this.supportedPhases;
    }

    public void setSupportedPhases(Set supportedPhases) {
        this.supportedPhases = supportedPhases;
    }

    public void registerSupportedPhase(String phase) {
        if (this.supportedPhases == null) {
            this.supportedPhases = new HashSet();
        }
        this.supportedPhases.add(phase);
    }

    public boolean isPhaseSupported(String phase) {
        if (this.getSupportedPhases() == null) {
            return true;
        }
        if (this.getSupportedPhases().contains("all")) {
            return true;
        }
        return this.getSupportedPhases().contains(phase);
    }

    public void applyLifecycle(Object o) throws LifecycleException {
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        if (!this.getLifecycleClass().isAssignableFrom(o.getClass())) {
            return;
        }
        try {
            this.lifecycleMethod.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(this.lifecycleMethod.getName(), o), e, this);
        }
    }

    public String getOppositeLifecyclePhase() {
        return this.oppositeLifecyclePhase;
    }
}

