/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.retry.RetryContext;

public class DefaultRetryContext
implements RetryContext {
    private MuleMessage[] returnMessages;
    private Map metaInfo = new HashMap();
    private String description;
    private Throwable lastFailure;
    private boolean failed = false;

    public DefaultRetryContext() {
    }

    public DefaultRetryContext(String description) {
        this.description = description;
    }

    public Map getMetaInfo() {
        return Collections.unmodifiableMap(this.metaInfo);
    }

    public void setMetaInfo(Map metaInfo) {
        if (metaInfo == null) {
            throw new IllegalArgumentException("Can't accept null meta-info map");
        }
        this.metaInfo = metaInfo;
    }

    public MuleMessage[] getReturnMessages() {
        return this.returnMessages;
    }

    public MuleMessage getFirstReturnMessage() {
        return this.returnMessages == null ? null : this.returnMessages[0];
    }

    public void setReturnMessages(MuleMessage[] returnMessages) {
        this.returnMessages = returnMessages;
    }

    public void addReturnMessage(MuleMessage result) {
        if (this.returnMessages == null) {
            this.returnMessages = new MuleMessage[]{result};
        } else {
            MuleMessage[] newReturnMessages = new MuleMessage[this.returnMessages.length + 1];
            System.arraycopy(newReturnMessages, 0, this.returnMessages, 0, 1);
            this.returnMessages = newReturnMessages;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Throwable getLastFailure() {
        return this.lastFailure;
    }

    public void setOk() {
        this.failed = false;
        this.lastFailure = null;
    }

    public boolean isOk() {
        return !this.failed;
    }

    public void setFailed(Throwable lastFailure) {
        this.failed = true;
        this.lastFailure = lastFailure;
    }
}

