/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.util.Comparator;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.ResequenceCorrelatorCallback;
import org.mule.routing.inbound.AbstractEventAggregator;
import org.mule.routing.inbound.CorrelationSequenceComparator;

public class CorrelationEventResequencer
extends AbstractEventAggregator {
    protected Comparator eventComparator;

    public CorrelationEventResequencer() {
        this.setEventComparator(new CorrelationSequenceComparator());
    }

    public void initialise() throws InitialisationException {
        if (this.eventComparator == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("eventComparator"), (Initialisable)this);
        }
        super.initialise();
    }

    public Comparator getEventComparator() {
        return this.eventComparator;
    }

    public void setEventComparator(Comparator eventComparator) {
        this.eventComparator = eventComparator;
    }

    protected EventCorrelatorCallback getCorrelatorCallback() {
        return new ResequenceCorrelatorCallback(this.getEventComparator());
    }

    public MuleEvent[] process(MuleEvent event) throws MessagingException {
        MuleMessage msg = this.eventCorrelator.process(event);
        if (msg == null) {
            return null;
        }
        return (MuleEvent[])msg.getPayload();
    }
}

