/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.routing.outbound.SplitMessage;

public abstract class AbstractMessageSplitter
extends FilteringOutboundRouter {
    public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
        String correlationId = this.messageInfoMapping.getCorrelationId(message);
        ArrayList<MuleMessage> results = new ArrayList<MuleMessage>();
        int correlationSequence = 1;
        SplitMessage splitMessage = this.getMessageParts(message, this.getEndpoints());
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propertyKey : message.getPropertyNames()) {
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        for (int i = 0; i < splitMessage.size(); ++i) {
            SplitMessage.MessagePart part = splitMessage.getPart(i);
            MuleMessage sendMessage = part.getPart() instanceof MuleMessage ? (MuleMessage)part.getPart() : new DefaultMuleMessage(part.getPart(), props);
            try {
                if (this.enableCorrelation != 2) {
                    boolean correlationSet;
                    boolean bl = correlationSet = message.getCorrelationId() != null;
                    if (!correlationSet && this.enableCorrelation == 0) {
                        sendMessage.setCorrelationId(correlationId);
                    }
                    sendMessage.setCorrelationGroupSize(splitMessage.size());
                    sendMessage.setCorrelationSequence(correlationSequence++);
                }
                boolean synchronous = part.getEndpoint().isSynchronous();
                sendMessage.setBooleanProperty("MULE_REMOTE_SYNC", part.getEndpoint().isSynchronous());
                if (synchronous) {
                    results.add(this.send(session, sendMessage, part.getEndpoint()));
                    continue;
                }
                this.dispatch(session, sendMessage, part.getEndpoint());
                continue;
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(sendMessage, part.getEndpoint(), (Throwable)e);
            }
        }
        return this.resultsHandler.aggregateResults(results, message);
    }

    protected abstract SplitMessage getMessageParts(MuleMessage var1, List var2);
}

