/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.routing.outbound.SplitMessage;

public class AbstractRoundRobinMessageSplitter
extends AbstractMessageSplitter {
    private boolean deterministic = true;
    private boolean disableRoundRobin = false;
    private static final AtomicInteger globalCounter = new AtomicInteger(0);
    private boolean failIfNoMatch = true;

    public void initialise() throws InitialisationException {
        if (this.isDisableRoundRobin()) {
            this.setDeterministic(true);
        }
        super.initialise();
    }

    protected List splitMessage(MuleMessage message) {
        if (message.getPayload() instanceof List) {
            return new LinkedList((List)message.getPayload());
        }
        throw new IllegalArgumentException(CoreMessages.objectNotOfCorrectType(message.getPayload().getClass(), List.class).getMessage());
    }

    protected SplitMessage getMessageParts(MuleMessage message, List endpoints) {
        SplitMessage splitMessage = new SplitMessage();
        List payloads = this.splitMessage(message);
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propertyKey : message.getPropertyNames()) {
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        Counter counter = new Counter();
        Iterator iterator = payloads.iterator();
        while (iterator.hasNext()) {
            Object payload = iterator.next();
            DefaultMuleMessage part = new DefaultMuleMessage(payload, props);
            boolean matchFound = false;
            for (int j = 0; j < endpoints.size(); ++j) {
                OutboundEndpoint endpoint = (OutboundEndpoint)endpoints.get(counter.next());
                if (endpoint.getFilter() != null && !endpoint.getFilter().accept(part)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Endpoint filter matched. Routing message over: " + endpoint.getEndpointURI().toString()));
                }
                iterator.remove();
                splitMessage.addPart(part, endpoint);
                matchFound = true;
                break;
            }
            if (!matchFound) {
                if (this.isFailIfNoMatch()) {
                    throw new IllegalStateException(CoreMessages.splitMessageNoEndpointMatch(endpoints, payload).getMessage());
                }
                this.logger.info((Object)"No splitter match for message part. 'failIfNoMatch=false' ingoring message part.");
            }
            if (!this.isDisableRoundRobin()) continue;
            counter = new Counter();
        }
        return splitMessage;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public boolean isDisableRoundRobin() {
        return this.disableRoundRobin;
    }

    public void setDisableRoundRobin(boolean disableRoundRobin) {
        this.disableRoundRobin = disableRoundRobin;
    }

    public boolean isFailIfNoMatch() {
        return this.failIfNoMatch;
    }

    public void setFailIfNoMatch(boolean failIfNoMatch) {
        this.failIfNoMatch = failIfNoMatch;
    }

    private class Counter {
        private AtomicInteger counter;

        public Counter() {
            this.counter = AbstractRoundRobinMessageSplitter.this.isDeterministic() ? new AtomicInteger(0) : globalCounter;
        }

        public int next() {
            return this.counter.getAndIncrement() % AbstractRoundRobinMessageSplitter.this.getEndpoints().size();
        }
    }
}

