/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan;

import java.io.IOException;
import org.mule.util.scan.ClassScanner;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class InterfaceClassScanner
extends EmptyVisitor
implements ClassScanner {
    private Class interfaceClass;
    private boolean match;
    private String className;

    public InterfaceClassScanner(Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("The class need to be an interface");
        }
        this.interfaceClass = interfaceClass;
    }

    public void visit(int i, int i1, String s, String s1, String superName, String[] interfaces) {
        if (interfaces != null && interfaces.length > 0) {
            for (int j = 0; j < interfaces.length; ++j) {
                String anInterface = interfaces[j].replace("/", ".");
                if (this.interfaceClass.getName().equals(anInterface)) {
                    this.match = true;
                    this.className = s;
                    break;
                }
                ClassScanner scanner = this.scan(anInterface);
                this.match = scanner.isMatch();
                this.className = s;
            }
        } else {
            if (superName == null) {
                return;
            }
            ClassScanner scanner = this.scan(superName);
            this.match = scanner.isMatch();
            this.className = scanner.getClassName();
            if (this.match) {
                this.className = s;
            }
        }
    }

    protected ClassScanner scan(String name) {
        try {
            InterfaceClassScanner scanner = new InterfaceClassScanner(this.interfaceClass);
            ClassReader r = new ClassReader(name);
            r.accept((ClassVisitor)scanner, 0);
            return scanner;
        }
        catch (IOException e) {
            throw new RuntimeException(name, e);
        }
    }

    public boolean isMatch() {
        return this.match;
    }

    public String getClassName() {
        return this.className;
    }
}

