/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageAdapter;
import org.mule.transport.jms.MessageRedeliveredException;
import org.mule.transport.jms.RedeliveryHandler;
import org.mule.transport.jms.i18n.JmsMessages;

public class CountingRedeliveryHandler
implements RedeliveryHandler {
    protected static final Log logger = LogFactory.getLog(CountingRedeliveryHandler.class);
    private Map<String, Integer> messages = Collections.synchronizedMap(new LRUMap(256));
    protected JmsConnector connector;

    public void setConnector(JmsConnector connector) {
        this.connector = connector;
    }

    public void handleRedelivery(Message message) throws JMSException, MessagingException {
        if (this.connector.getMaxRedelivery() <= 0) {
            return;
        }
        String id = message.getJMSMessageID();
        if (id == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message doesn't have a JMSMessageID set, Mule can't handle redelivery for it. " + message));
            }
            return;
        }
        Integer redeliveryCount = this.messages.remove(id);
        if (redeliveryCount != null) {
            redeliveryCount = redeliveryCount + 1;
        }
        if (redeliveryCount == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered for the first time"));
            }
            this.messages.put(id, 1);
        } else {
            if (redeliveryCount > this.connector.getMaxRedelivery()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("Message with id: {0} has been redelivered {1} times, which exceeds the maxRedelivery setting of {2} on the connector {3}", id, redeliveryCount, this.connector.getMaxRedelivery(), this.connector.getName()));
                }
                JmsMessageAdapter adapter = (JmsMessageAdapter)this.connector.getMessageAdapter(message);
                throw new MessageRedeliveredException(JmsMessages.tooManyRedeliveries(id, "" + redeliveryCount, this.connector.getMaxRedelivery(), this.connector.getName()), adapter);
            }
            this.messages.put(id, redeliveryCount);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered " + redeliveryCount + " times"));
            }
        }
    }
}

