/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.remoting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.springframework.remoting.support.RemoteInvocation;

public class ObjectToRemoteInvocationTransformer
extends AbstractTransformer {
    public ObjectToRemoteInvocationTransformer() {
        this.registerSourceType(RemoteInvocation.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass(RemoteInvocation.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        if (src instanceof RemoteInvocation) {
            return src;
        }
        Object o = null;
        if (src instanceof InputStream) {
            try {
                o = new ObjectInputStream((InputStream)src).readObject();
            }
            catch (Exception e) {
                throw new TransformerException(this, (Throwable)e);
            }
        }
        byte[] data = (byte[])src;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            o = ois.readObject();
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
        RemoteInvocation ri = (RemoteInvocation)o;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("request to execute " + ri.getMethodName()));
            for (int i = 0; i < ri.getArguments().length; ++i) {
                Object a = ri.getArguments()[i];
                this.logger.debug((Object)("with argument (" + a.toString() + ")"));
            }
        }
        return ri;
    }
}

