/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import javax.resource.spi.work.Work;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.config.ThreadingProfile;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.work.MuleWorkManager;

public class MuleWorkManagerTestCase
extends AbstractMuleTestCase {
    private final transient Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoWorkExecutesSynchronously() throws Exception {
        final Thread callerThread = Thread.currentThread();
        MuleWorkManager wm = new MuleWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, null);
        try {
            wm.start();
            wm.doWork(new Work(){

                public void release() {
                }

                public void run() {
                    Thread calleeThread = Thread.currentThread();
                    Assert.assertEquals((String)"WorkManager.doWork() should have been executed in the same thread.", (Object)callerThread, (Object)calleeThread);
                    if (MuleWorkManagerTestCase.this.logger.isDebugEnabled()) {
                        MuleWorkManagerTestCase.this.logger.debug((Object)("WORK: " + Thread.currentThread()));
                    }
                }
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MAIN: " + Thread.currentThread()));
            }
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduleWorkExecutesAsynchronously() throws Exception {
        final Thread callerThread = Thread.currentThread();
        MuleWorkManager wm = new MuleWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, null);
        try {
            wm.start();
            wm.scheduleWork(new Work(){

                public void release() {
                }

                public void run() {
                    Thread calleeThread = Thread.currentThread();
                    Assert.assertFalse((String)"WorkManager.scheduleWork() should have been executed in a different thread.", (boolean)callerThread.equals(calleeThread));
                    if (MuleWorkManagerTestCase.this.logger.isDebugEnabled()) {
                        MuleWorkManagerTestCase.this.logger.debug((Object)("WORK: " + Thread.currentThread()));
                    }
                }
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MAIN: " + Thread.currentThread()));
            }
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartWorkExecutesAsynchronously() throws Exception {
        final Thread callerThread = Thread.currentThread();
        MuleWorkManager wm = new MuleWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, null);
        try {
            wm.start();
            wm.startWork(new Work(){

                public void release() {
                }

                public void run() {
                    Thread calleeThread = Thread.currentThread();
                    Assert.assertFalse((String)"WorkManager.startWork() should have been executed in a different thread.", (boolean)callerThread.equals(calleeThread));
                    if (MuleWorkManagerTestCase.this.logger.isDebugEnabled()) {
                        MuleWorkManagerTestCase.this.logger.debug((Object)("WORK: " + Thread.currentThread()));
                    }
                }
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MAIN: " + Thread.currentThread()));
            }
        }
        finally {
            wm.dispose();
        }
    }
}

